/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeaderResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ForeignKeyRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PrimaryKeyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.SchemaExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/asset-manager/overview/"))
public class SchemaExchangeResource {
    private SchemaExchangeRESTServices restAPI = new SchemaExchangeRESTServices();

    @PostMapping(path={"/schema-types"})
    public GUIDResponse createSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.createSchemaType(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-types/from-template/{templateGUID}"})
    public GUIDResponse createSchemaTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaTypeFromTemplate(serverName, userId, templateGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}"})
    public VoidResponse updateSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.updateSchemaType(serverName, userId, schemaTypeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementGUID}/{parentElementTypeName}/schema-types/{schemaTypeGUID}"})
    public VoidResponse setupSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @PathVariable String schemaTypeGUID, @RequestParam boolean assetManagerIsHome, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.setupSchemaTypeParent(serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementGUID}/{parentElementTypeName}/schema-types/{schemaTypeGUID}/remove"})
    public VoidResponse clearSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @PathVariable String schemaTypeGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearSchemaTypeParent(serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}/remove"})
    public VoidResponse removeSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.removeSchemaType(serverName, userId, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/by-search-string"})
    public SchemaTypeElementsResponse findSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSchemaType(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementGUID}/schema-types/retrieve"})
    public SchemaTypeElementResponse getSchemaTypeForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getSchemaTypeForElement(serverName, userId, parentElementGUID, parentElementTypeName, requestBody);
    }

    @PostMapping(path={"/schema-types/by-name"})
    public SchemaTypeElementsResponse getSchemaTypeByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getSchemaTypeByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}/retrieve"})
    public SchemaTypeElementResponse getSchemaTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getSchemaTypeByGUID(serverName, userId, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/parents/schema-types/{schemaTypeGUID}/retrieve"})
    public ElementHeaderResponse getSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getSchemaTypeParent(serverName, userId, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/schema-attribute"})
    public GUIDResponse createSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestParam boolean assetManagerIsHome, @RequestBody SchemaAttributeRequestBody requestBody) {
        return this.restAPI.createSchemaAttribute(serverName, userId, schemaElementGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/schema-attributes/from-template/{templateGUID}"})
    public GUIDResponse createSchemaAttributeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaAttributeFromTemplate(serverName, userId, schemaElementGUID, templateGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}"})
    public VoidResponse updateSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam boolean isMergeUpdate, @RequestBody SchemaAttributeRequestBody requestBody) {
        return this.restAPI.updateSchemaAttribute(serverName, userId, schemaAttributeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/is-calculated-value"})
    public VoidResponse setSchemaElementAsCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestParam boolean assetManagerIsHome, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.setSchemaElementAsCalculatedValue(serverName, userId, schemaElementGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/is-calculated-value/remove"})
    public VoidResponse clearSchemaElementAsCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearSchemaElementAsCalculatedValue(serverName, userId, schemaElementGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/is-primary-key"})
    public VoidResponse setupColumnAsPrimaryKey(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam boolean assetManagerIsHome, @RequestBody PrimaryKeyClassificationRequestBody requestBody) {
        return this.restAPI.setupColumnAsPrimaryKey(serverName, userId, schemaAttributeGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/is-primary-key/remove"})
    public VoidResponse clearColumnAsPrimaryKey(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearColumnAsPrimaryKey(serverName, userId, schemaAttributeGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{primaryKeyGUID}/relationships/foreign-keys"})
    public VoidResponse setupForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyGUID, @PathVariable String foreignKeyGUID, @RequestParam boolean assetManagerIsHome, @RequestBody ForeignKeyRequestBody requestBody) {
        return this.restAPI.setupForeignKeyRelationship(serverName, userId, primaryKeyGUID, foreignKeyGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{primaryKeyGUID}/relationships/foreign-keys/update"})
    public VoidResponse updateForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyGUID, @PathVariable String foreignKeyGUID, @RequestBody ForeignKeyRequestBody requestBody) {
        return this.restAPI.updateForeignKeyRelationship(serverName, userId, primaryKeyGUID, foreignKeyGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{primaryKeyGUID}/relationships/foreign-keys/remove"})
    public VoidResponse clearForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyGUID, @PathVariable String foreignKeyGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearForeignKeyRelationship(serverName, userId, primaryKeyGUID, foreignKeyGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/remove"})
    public VoidResponse removeSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.removeSchemaAttribute(serverName, userId, schemaAttributeGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/by-search-string"})
    public SchemaAttributeElementsResponse findSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSchemaAttributes(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-elements/{parentSchemaElementGUID}/schema-attributes/retrieve"})
    public SchemaAttributeElementsResponse getNestedAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentSchemaElementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getNestedAttributes(serverName, userId, parentSchemaElementGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-attributes/by-name"})
    public SchemaAttributeElementsResponse getSchemaAttributesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @PathVariable NameRequestBody requestBody) {
        return this.restAPI.getSchemaAttributesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/retrieve"})
    public SchemaAttributeElementResponse getSchemaAttributeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getSchemaAttributeByGUID(serverName, userId, schemaAttributeGUID, requestBody);
    }
}

