/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.ConnectionExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/asset-manager/overview/"))
public class ConnectionExchangeResource {
    private final ConnectionExchangeRESTServices restAPI = new ConnectionExchangeRESTServices();

    @PostMapping(path={"/connections"})
    public GUIDResponse createConnection(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody ConnectionRequestBody requestBody) {
        return this.restAPI.createConnection(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/connections/from-template/{templateGUID}"})
    public GUIDResponse createConnectionFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createConnectionFromTemplate(serverName, userId, templateGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}"})
    public VoidResponse updateConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @RequestParam boolean isMergeUpdate, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody ConnectionRequestBody requestBody) {
        return this.restAPI.updateConnection(serverName, userId, connectionGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/connector-types/{connectorTypeGUID}"})
    public VoidResponse setupConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String connectorTypeGUID, @RequestParam boolean assetManagerIsHome, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupConnectorType(serverName, userId, connectionGUID, connectorTypeGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/connector-types/{connectorTypeGUID}/remove"})
    public VoidResponse clearConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String connectorTypeGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearConnectorType(serverName, userId, connectionGUID, connectorTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/endpoints/{endpointGUID}"})
    public VoidResponse setupEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String endpointGUID, @RequestParam boolean assetManagerIsHome, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupEndpoint(serverName, userId, connectionGUID, endpointGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/endpoints/{endpointGUID}/remove"})
    public VoidResponse clearEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String endpointGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearEndpoint(serverName, userId, connectionGUID, endpointGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/embedded-connections/{embeddedConnectionGUID}"})
    public VoidResponse setupEmbeddedConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String embeddedConnectionGUID, @RequestParam boolean assetManagerIsHome, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupEmbeddedConnection(serverName, userId, connectionGUID, embeddedConnectionGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/embedded-connections/{embeddedConnectionGUID}/remove"})
    public VoidResponse clearEmbeddedConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String embeddedConnectionGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearEmbeddedConnection(serverName, userId, connectionGUID, embeddedConnectionGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/connections/{connectionGUID}"})
    public VoidResponse setupAssetConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID, @RequestParam boolean assetManagerIsHome, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAssetConnection(serverName, userId, assetManagerIsHome, assetGUID, connectionGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/connections/{connectionGUID}/remove"})
    public VoidResponse clearAssetConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearAssetConnection(serverName, userId, assetGUID, connectionGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/remove"})
    public VoidResponse removeConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeConnection(serverName, userId, connectionGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/by-search-string"})
    public ConnectionsResponse findConnections(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findConnections(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/by-name"})
    public ConnectionsResponse getConnectionsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getConnectionsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/by-asset-manager"})
    public ConnectionsResponse getConnectionsForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getConnectionsForAssetManager(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/retrieve"})
    public ConnectionResponse getConnectionByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getConnectionByGUID(serverName, userId, connectionGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/endpoints"})
    public GUIDResponse createEndpoint(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.createEndpoint(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/endpoints/from-template/{templateGUID}"})
    public GUIDResponse createEndpointFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createEndpointFromTemplate(serverName, userId, templateGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}"})
    public VoidResponse updateEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam boolean isMergeUpdate, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.updateEndpoint(serverName, userId, endpointGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}/remove"})
    public VoidResponse removeEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeEndpoint(serverName, userId, endpointGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/endpoints/by-search-string"})
    public EndpointsResponse findEndpoints(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findEndpoints(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/endpoints/by-name"})
    public EndpointsResponse getEndpointsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getEndpointsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/endpoints/by-asset-manager"})
    public EndpointsResponse getEndpointsForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getEndpointsForAssetManager(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}/retrieve"})
    public EndpointResponse getEndpointByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getEndpointByGUID(serverName, userId, endpointGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connector-types"})
    public GUIDResponse createConnectorType(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody ConnectorTypeRequestBody requestBody) {
        return this.restAPI.createConnectorType(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/connector-types/from-template/{templateGUID}"})
    public GUIDResponse createConnectorTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createConnectorTypeFromTemplate(serverName, userId, templateGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/connector-types/{connectorTypeGUID}"})
    public VoidResponse updateConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID, @RequestParam boolean isMergeUpdate, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody ConnectorTypeRequestBody requestBody) {
        return this.restAPI.updateConnectorType(serverName, userId, connectorTypeGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connector-types/{connectorTypeGUID}/remove"})
    public VoidResponse removeConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeConnectorType(serverName, userId, connectorTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connector-types/by-search-string"})
    public ConnectorTypesResponse findConnectorTypes(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findConnectorTypes(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connector-types/by-name"})
    public ConnectorTypesResponse getConnectorTypesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getConnectorTypesByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connector-types/by-asset-manager"})
    public ConnectorTypesResponse getConnectorTypesForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getConnectorTypesForAssetManager(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/connector-types/{connectorTypeGUID}/retrieve"})
    public ConnectorTypeResponse getConnectorTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getConnectorTypeByGUID(serverName, userId, connectorTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }
}

