/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ArchiveRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryElementLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.HistoryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.GlossaryExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/asset-manager/overview"))
public class GlossaryExchangeResource {
    private final GlossaryExchangeRESTServices restAPI = new GlossaryExchangeRESTServices();

    @PostMapping(path={"/glossaries"})
    public GUIDResponse createGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createGlossary(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/glossaries/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="true") boolean deepCopy, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryFromTemplate(serverName, userId, assetManagerIsHome, templateGUID, deepCopy, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/update"})
    public VoidResponse updateGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossary(serverName, userId, glossaryGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/remove"})
    public VoidResponse removeGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-editing-glossary"})
    public VoidResponse setGlossaryAsEditingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsEditingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-editing-glossary/remove"})
    public VoidResponse clearGlossaryAsEditingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsEditingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-staging-glossary"})
    public VoidResponse setGlossaryAsStagingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsStagingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-staging-glossary/remove"})
    public VoidResponse clearGlossaryAsStagingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsStagingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy"})
    public VoidResponse setGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsTaxonomy(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy/remove"})
    public VoidResponse clearGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsTaxonomy(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical"})
    public VoidResponse setGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsCanonical(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical/remove"})
    public VoidResponse clearGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsCanonical(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/by-search-string"})
    public GlossaryElementsResponse findGlossaries(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaries(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/by-name"})
    public GlossaryElementsResponse getGlossariesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGlossariesByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/by-asset-manager"})
    public GlossaryElementsResponse getGlossariesForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossariesForAssetManager(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/retrieve"})
    public GlossaryElementResponse getGlossaryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryByGUID(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/for-category/{glossaryCategoryGUID}/retrieve"})
    public GlossaryElementResponse getGlossaryForCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryForCategory(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/for-term/{glossaryTermGUID}/retrieve"})
    public GlossaryElementResponse getGlossaryForTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryForTerm(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories"})
    public GUIDResponse createGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean isRootCategory, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createGlossaryCategory(serverName, userId, glossaryGUID, assetManagerIsHome, isRootCategory, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryCategoryFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @PathVariable String templateGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="true") boolean deepCopy, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryCategoryFromTemplate(serverName, userId, glossaryGUID, templateGUID, assetManagerIsHome, deepCopy, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/update"})
    public VoidResponse updateGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryCategory(serverName, userId, glossaryCategoryGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}"})
    public VoidResponse setupCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupCategoryParent(serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}/remove"})
    public VoidResponse clearCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearCategoryParent(serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/remove"})
    public VoidResponse removeGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossaryCategory(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-search-string"})
    public GlossaryCategoryElementsResponse findGlossaryCategories(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossarySearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryCategories(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories/retrieve"})
    public GlossaryCategoryElementsResponse getCategoriesForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCategoriesForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/categories/retrieve"})
    public GlossaryCategoryElementsResponse getCategoriesForTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCategoriesForTerm(serverName, userId, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-name"})
    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryNameRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoriesByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/retrieve"})
    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryByGUID(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/parent/retrieve"})
    public GlossaryCategoryElementResponse getGlossaryCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryParent(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/subcategories/retrieve"})
    public GlossaryCategoryElementsResponse getGlossarySubCategories(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossarySubCategories(serverName, userId, glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms"})
    public GUIDResponse createGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createGlossaryTerm(serverName, userId, glossaryGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/new-controlled"})
    public GUIDResponse createControlledGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ControlledGlossaryTermRequestBody requestBody) {
        return this.restAPI.createControlledGlossaryTerm(serverName, userId, glossaryGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryTermFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @PathVariable String templateGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="true") boolean deepCopy, @RequestParam(required=false, defaultValue="true") boolean templateSubstitute, @RequestBody GlossaryTemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryTermFromTemplate(serverName, userId, glossaryGUID, templateGUID, assetManagerIsHome, deepCopy, templateSubstitute, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/update"})
    public VoidResponse updateGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryTerm(serverName, userId, glossaryTermGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/status"})
    public VoidResponse updateGlossaryTermStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryTermStatusRequestBody requestBody) {
        return this.restAPI.updateGlossaryTermStatus(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/update/from-template"})
    public VoidResponse updateGlossaryTermFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeClassifications, @RequestParam(required=false, defaultValue="false") boolean isMergeProperties, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryTermFromTemplate(serverName, userId, glossaryTermGUID, isMergeClassifications, isMergeProperties, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/move"})
    public VoidResponse moveGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.moveGlossaryTerm(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}"})
    public VoidResponse setupTermCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupTermCategory(serverName, userId, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}/remove"})
    public VoidResponse clearTermCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearTermCategory(serverName, userId, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @GetMapping(path={"/glossaries/terms/relationships/type-names"})
    public NameListResponse getTermRelationshipTypeNames(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTermRelationshipTypeNames(serverName, userId);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}"})
    public VoidResponse setupTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/update"})
    public VoidResponse updateTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/remove"})
    public VoidResponse clearTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept"})
    public VoidResponse setTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsAbstractConcept(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept/remove"})
    public VoidResponse clearTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsAbstractConcept(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value"})
    public VoidResponse setTermAsDataValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsDataValue(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value/remove"})
    public VoidResponse clearTermAsDataValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsDataValue(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-field"})
    public VoidResponse setTermAsDataField(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsDataField(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-field/remove"})
    public VoidResponse clearTermAsDataField(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsDataField(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity"})
    public VoidResponse setTermAsActivity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsActivity(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity/remove"})
    public VoidResponse clearTermAsActivity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsActivity(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition"})
    public VoidResponse setTermAsContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsContext(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition/remove"})
    public VoidResponse clearTermAsContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsContext(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object"})
    public VoidResponse setTermAsSpineObject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsSpineObject(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object/remove"})
    public VoidResponse clearTermAsSpineObject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsSpineObject(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute"})
    public VoidResponse setTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsSpineAttribute(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute/remove"})
    public VoidResponse clearTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsSpineAttribute(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier"})
    public VoidResponse setTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsObjectIdentifier(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier/remove"})
    public VoidResponse clearTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsObjectIdentifier(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/undo"})
    public GlossaryTermElementResponse undoGlossaryTermUpdate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.undoGlossaryTermUpdate(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/archive"})
    public VoidResponse archiveGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ArchiveRequestBody requestBody) {
        return this.restAPI.archiveGlossaryTerm(serverName, userId, glossaryTermGUID, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/remove"})
    public VoidResponse removeGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossaryTerm(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-search-string"})
    public GlossaryTermElementsResponse findGlossaryTerms(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossarySearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryTerms(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/retrieve"})
    public GlossaryTermElementsResponse getTermsForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getTermsForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/retrieve"})
    public GlossaryTermElementsResponse getTermsForGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) GlossaryTermRelationshipRequestBody requestBody) {
        return this.restAPI.getTermsForGlossaryCategory(serverName, userId, glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/related-terms"})
    public GlossaryTermElementsResponse getRelatedTerms(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) GlossaryTermRelationshipRequestBody requestBody) {
        return this.restAPI.getRelatedTerms(serverName, userId, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-name"})
    public GlossaryTermElementsResponse getGlossaryTermsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryNameRequestBody requestBody) {
        return this.restAPI.getGlossaryTermsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/retrieve"})
    public GlossaryTermElementResponse getGlossaryTermByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryTermByGUID(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/history"})
    public GlossaryTermElementsResponse getGlossaryTermHistory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean oldestFirst, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) HistoryRequestBody requestBody) {
        return this.restAPI.getGlossaryTermHistory(serverName, userId, glossaryTermGUID, startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/external-links"})
    public GUIDResponse createExternalGlossaryLink(@PathVariable String serverName, @PathVariable String userId, @RequestBody ExternalGlossaryLinkRequestBody requestBody) {
        return this.restAPI.createExternalGlossaryLink(serverName, userId, requestBody);
    }

    @PostMapping(path={"/glossaries/external-links/{externalLinkGUID}"})
    public VoidResponse updateExternalGlossaryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ExternalGlossaryLinkRequestBody requestBody) {
        return this.restAPI.updateExternalGlossaryLink(serverName, userId, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/external-links/{externalLinkGUID}/remove"})
    public VoidResponse removeExternalGlossaryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeExternalGlossaryLink(serverName, userId, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/external-links/{externalLinkGUID}"})
    public VoidResponse attachExternalLinkToGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @PathVariable String externalLinkGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.attachExternalLinkToGlossary(serverName, userId, glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/external-links/{externalLinkGUID}/remove"})
    public VoidResponse detachExternalLinkFromGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.detachExternalLinkFromGlossary(serverName, userId, externalLinkGUID, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/external-links/retrieve"})
    public ExternalGlossaryLinkElementsResponse getExternalLinksForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getExternalLinksForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/external-links/{externalLinkGUID}/retrieve"})
    public GlossaryElementsResponse getGlossariesForExternalLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossariesForExternalLink(serverName, userId, externalLinkGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/external-links/{externalLinkGUID}"})
    public VoidResponse attachExternalCategoryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String externalLinkGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ExternalGlossaryElementLinkRequestBody requestBody) {
        return this.restAPI.attachExternalCategoryLink(serverName, userId, glossaryCategoryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/external-links/{externalLinkGUID}/remove"})
    public VoidResponse detachExternalCategoryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.detachExternalCategoryLink(serverName, userId, externalLinkGUID, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/external-links/{externalLinkGUID}"})
    public VoidResponse attachExternalTermLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ExternalGlossaryElementLinkRequestBody requestBody) {
        return this.restAPI.attachExternalTermLink(serverName, userId, externalLinkGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/external-links/{externalLinkGUID}/remove"})
    public VoidResponse detachExternalTermLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.detachExternalTermLink(serverName, userId, externalLinkGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }
}

