/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.StewardshipExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/asset-manager/overview/"))
public class StewardshipExchangeResource {
    private final StewardshipExchangeRESTServices restAPI = new StewardshipExchangeRESTServices();

    @PostMapping(path={"/elements/{elementGUID}/data-field"})
    public VoidResponse setDataFieldClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setDataFieldClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/data-field/remove"})
    public VoidResponse clearDataFieldClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearDataFieldClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-data-field"})
    public ElementStubsResponse getDataFieldClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getDataFieldClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidence"})
    public VoidResponse setConfidenceClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setConfidenceClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidence/remove"})
    public VoidResponse clearConfidenceClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearConfidenceClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-confidence"})
    public ElementStubsResponse getConfidenceClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getConfidenceClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/criticality"})
    public VoidResponse setCriticalityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setCriticalityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/criticality/remove"})
    public VoidResponse clearCriticalityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearCriticalityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-criticality"})
    public ElementStubsResponse getCriticalityClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getCriticalityClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidentiality"})
    public VoidResponse setConfidentialityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setConfidentialityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidentiality/remove"})
    public VoidResponse clearConfidentialityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearConfidentialityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-confidentiality"})
    public ElementStubsResponse getConfidentialityClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getConfidentialityClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/retention"})
    public VoidResponse setRetentionClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setRetentionClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/retention/remove"})
    public VoidResponse clearRetentionClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearRetentionClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-retention"})
    public ElementStubsResponse getRetentionClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getRetentionClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/security-tags/remove"})
    public VoidResponse removeSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.removeSecurityTags(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-security-tags"})
    public ElementStubsResponse getSecurityTaggedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getSecurityTaggedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ownership"})
    public VoidResponse addOwnership(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addOwnership(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ownership/remove"})
    public VoidResponse clearOwnership(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearOwnership(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-ownership"})
    public ElementStubsResponse getOwnersElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getOwnersElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin"})
    public VoidResponse addAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addAssetOrigin(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin/remove"})
    public VoidResponse clearAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearAssetOrigin(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/asset/by-origin"})
    public AssetElementsResponse getAssetsByOrigin(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getAssetsByOrigin(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/subject-area-member"})
    public VoidResponse addElementToSubjectArea(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addElementToSubjectArea(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/subject-area-member/remove"})
    public VoidResponse removeElementFromSubjectArea(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.removeElementFromSubjectArea(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-subject-area-membership"})
    public ElementStubsResponse getMembersOfSubjectArea(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getMembersOfSubjectArea(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/semantic-assignment/terms/{glossaryTermGUID}"})
    public VoidResponse setupSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupSemanticAssignment(serverName, userId, elementGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/semantic-assignment/terms/{glossaryTermGUID}/remove"})
    public VoidResponse clearSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearSemanticAssignment(serverName, userId, elementGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/glossaries/terms/by-semantic-assignment/{elementGUID}"})
    public GlossaryTermElementsResponse getMeanings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getMeanings(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/elements/by-semantic-assignment/{glossaryTermGUID}"})
    public RelatedElementsResponse getSemanticAssignees(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSemanticAssignees(serverName, userId, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by/definition/{definitionGUID}"})
    public VoidResponse addGovernanceDefinitionToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.addGovernanceDefinitionToElement(serverName, userId, definitionGUID, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by/definition/{definitionGUID}/remove"})
    public VoidResponse removeGovernanceDefinitionFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeGovernanceDefinitionFromElement(serverName, userId, definitionGUID, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/governed-by/{governanceDefinitionGUID}"})
    public RelatedElementsResponse getGovernedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGovernedElements(serverName, userId, governanceDefinitionGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by"})
    public GovernanceDefinitionsResponse getGovernedByDefinitions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGovernedByDefinitions(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/sourced-from/{elementGUID}"})
    public RelatedElementsResponse getSourceElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSourceElements(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/sourced-from"})
    public RelatedElementsResponse getElementsSourceFrom(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getElementsSourceFrom(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }
}

