/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FeedbackProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TagProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.CollaborationExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-manager/overview/"))
public class CollaborationExchangeResource {
    private final CollaborationExchangeRESTServices restAPI = new CollaborationExchangeRESTServices();

    @PostMapping(path={"/comments/{commentGUID}/replies"})
    @Operation(summary="addCommentReply", description="Adds a reply to a comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestParam boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentReply(serverName, userId, commentGUID, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments"})
    @Operation(summary="addCommentToElement", description="Creates a comment and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentToElement(serverName, userId, elementGUID, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes"})
    @Operation(summary="addLikeToElement", description="Creates a <i>like</i> object and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addLikeToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addLikeToElement(serverName, userId, elementGUID, isPublic, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings"})
    @Operation(summary="addRatingToElement", description="Adds a star rating and optional review text to the element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addRatingToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestBody RatingProperties requestBody) {
        return this.restAPI.addRatingToElement(serverName, userId, elementGUID, isPublic, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}"})
    @Operation(summary="addTagToElement", description="Adds an informal tag (either private of public) to an element.", externalDocs=@ExternalDocumentation(description="Element Classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse addTagToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody FeedbackProperties requestBody) {
        return this.restAPI.addTagToElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/tags"})
    @Operation(summary="createInformalTag", description="Creates a new informal tag and returns the unique identifier for it.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public GUIDResponse createInformalTag(@PathVariable String serverName, @PathVariable String userId, @RequestBody TagProperties requestBody) {
        return this.restAPI.createInformalTag(serverName, userId, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/remove"})
    @Operation(summary="deleteTag", description="Removes an informal tag from the repository.  All the tagging relationships to this informal tag are lost.  A private tag can be deleted by its creator and all the references are lost; a public tag can be deleted by anyone, but only if it is not attached to any referenceable.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, userId, tagGUID, requestBody);
    }

    @GetMapping(path={"/elements/by-tag/{tagGUID}"})
    @Operation(summary="getElementsByTag", description="Return the list of unique identifiers for elements that are linked to a specific tag either directly, or via one of its schema elements.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public GUIDListResponse getElementsByTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getElementsByTag(serverName, userId, tagGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/tags/{tagGUID}"})
    @Operation(summary="getTag", description="Return the informal tag for the supplied unique identifier (tagGUID).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagResponse getTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID) {
        return this.restAPI.getTag(serverName, userId, tagGUID);
    }

    @PostMapping(path={"/tags/by-name"})
    @Operation(summary="getTagsByName", description="Return the tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getTagsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/private/by-name"})
    @Operation(summary="getMyTagsByName", description="Return the list of the calling user's private informal tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getMyTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMyTagsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/by-search-string"})
    @Operation(summary="findTags", description="Return the list of informal tags containing the supplied string in either the name or description. The search string is a regular expression (RegEx).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findTags(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/private/by-search-string"})
    @Operation(summary="findMyTags", description="Return the list of the calling user's private tags containing the supplied string in either the name or description.  The search string is a regular expression (RegEx).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findMyTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMyTags(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments/{commentGUID}/remove"})
    @Operation(summary="removeCommentFromElement", description="Removes a comment added to the element by this user.  This deletes the link to the comment, the comment itself and any comment replies attached to it.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeCommentFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeCommentFromElement(serverName, userId, elementGUID, commentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}"})
    public CommentElementResponse getComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCommentByGUID(serverName, userId, commentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments/retrieve"})
    public CommentElementsResponse getAttachedComments(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAttachedComments(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes/remove"})
    @Operation(summary="removeLikeFromElement", description="Removes a <i>Like</i> added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#element-feedback"))
    public VoidResponse removeLikeFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeLikeFromElement(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings/remove"})
    @Operation(summary="removeRatingFromElement", description="Removes of a star rating/review that was added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeRatingFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeRatingFromElement(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}/remove"})
    @Operation(summary="removeTagFromElement", description="Removes a link between a tag and an element that was added by this user.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse removeTagFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTagFromElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}/update"})
    @Operation(summary="updateComment", description="Update an existing comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateComment(serverName, userId, commentGUID, isMergeUpdate, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}"})
    public VoidResponse setupAcceptedAnswer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAcceptedAnswer(serverName, userId, questionCommentGUID, answerCommentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}/remove"})
    public VoidResponse clearAcceptedAnswer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearAcceptedAnswer(serverName, userId, questionCommentGUID, answerCommentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/update"})
    @Operation(summary="updateTagDescription", description="Updates the description of an existing tag (either private or public).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody InformalTagUpdateRequestBody requestBody) {
        return this.restAPI.updateTagDescription(serverName, userId, tagGUID, requestBody);
    }

    @PostMapping(value={"/elements/{elementGUID}/note-logs"})
    public GUIDResponse createNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="true") boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createNoteLog(serverName, userId, elementGUID, assetManagerIsHome, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/update"})
    public VoidResponse updateNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="true") boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateNoteLog(serverName, userId, noteLogGUID, isMergeUpdate, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/remove"})
    public VoidResponse removeNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeNoteLog(serverName, userId, noteLogGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/by-search-string"})
    public NoteLogElementsResponse findNoteLogs(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findNoteLogs(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/by-name"})
    public NoteLogElementsResponse getNoteLogsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getNoteLogsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/elements/{elementGUID}/note-logs/retrieve"})
    public NoteLogElementsResponse getNoteLogsForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteLogsForElement(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/retrieve"})
    public NoteLogElementResponse getNoteLogByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteLogByGUID(serverName, userId, noteLogGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/notes"})
    public GUIDResponse createNote(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createNote(serverName, userId, assetManagerIsHome, noteLogGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}/update"})
    public VoidResponse updateNote(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateNote(serverName, userId, noteGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}/remove"})
    public VoidResponse removeNote(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeNote(serverName, userId, noteGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/by-search-string"})
    public NoteElementsResponse findNotes(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findNotes(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/notes/retrieve"})
    public NoteElementsResponse getNotesForNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNotesForNoteLog(serverName, userId, noteLogGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}/retrieve"})
    public NoteElementResponse getNoteByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteByGUID(serverName, userId, noteGUID, forLineage, forDuplicateProcessing, requestBody);
    }
}

