/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.DataAssetExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-manager/overview/"))
public class DataAssetExchangeResource {
    private final DataAssetExchangeRESTServices restAPI = new DataAssetExchangeRESTServices();

    @PostMapping(path={"/data-assets"})
    public GUIDResponse createDataAsset(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody DataAssetRequestBody requestBody) {
        return this.restAPI.createDataAsset(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/data-assets/from-template/{templateGUID}"})
    public GUIDResponse createDataAssetFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createDataAssetFromTemplate(serverName, userId, assetManagerIsHome, templateGUID, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}"})
    public VoidResponse updateDataAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody DataAssetRequestBody requestBody) {
        return this.restAPI.updateDataAsset(serverName, userId, assetGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/publish"})
    public VoidResponse publishDataAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.publishDataAsset(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/withdraw"})
    public VoidResponse withdrawDataAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.withdrawDataAsset(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/remove"})
    public VoidResponse removeDataAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.removeDataAsset(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/is-reference-data"})
    public VoidResponse setDataAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.setDataAssetAsReferenceData(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/is-reference-data/remove"})
    public VoidResponse clearDataAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.clearDataAssetAsReferenceData(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/relationships/{relationshipTypeName}/from-asset/{fromAssetGUID}/to-asset/{toAssetGUID}"})
    public GUIDResponse setupRelatedDataAsset(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @PathVariable String relationshipTypeName, @PathVariable String fromAssetGUID, @PathVariable String toAssetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupRelatedDataAsset(serverName, userId, assetManagerIsHome, relationshipTypeName, fromAssetGUID, toAssetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/relationships/{relationshipTypeName}/from-asset/{fromAssetGUID}/to-asset/{toAssetGUID}/retrieve"})
    public RelationshipElementResponse getAssetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String fromAssetGUID, @PathVariable String toAssetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAssetRelationship(serverName, userId, relationshipTypeName, fromAssetGUID, toAssetGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/relationships/{relationshipTypeName}/{relationshipGUID}/update"})
    public VoidResponse updateAssetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String relationshipGUID, @RequestParam boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateAssetRelationship(serverName, userId, relationshipTypeName, relationshipGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/relationships/{relationshipTypeName}/{relationshipGUID}/remove"})
    public VoidResponse clearAssetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String relationshipGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearAssetRelationship(serverName, userId, relationshipTypeName, relationshipGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/relationships/{relationshipTypeName}/from-asset/{fromAssetGUID}/retrieve/end2"})
    public RelationshipElementsResponse getRelatedAssetsAtEnd2(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String fromAssetGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getRelatedAssetsAtEnd2(serverName, userId, relationshipTypeName, fromAssetGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/data-assets/relationships/{relationshipTypeName}/to-asset/{toAssetGUID}/retrieve/end1"})
    public RelationshipElementsResponse getRelatedAssetsAtEnd1(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String toAssetGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getRelatedAssetsAtEnd1(serverName, userId, relationshipTypeName, toAssetGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/by-search-string"})
    public DataAssetElementsResponse findDataAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findDataAssets(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/scan"})
    public DataAssetElementsResponse scanDataAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.scanDataAssets(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/by-name"})
    public DataAssetElementsResponse getDataAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getDataAssetsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/by-asset-manager"})
    public DataAssetElementsResponse getDataAssetsForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getDataAssetsForAssetManager(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/retrieve"})
    public DataAssetElementResponse getDataAssetByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getDataAssetByGUID(serverName, userId, assetGUID, forLineage, forDuplicateProcessing, requestBody);
    }
}

