/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CalculatedValueClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeaderResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ForeignKeyRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PrimaryKeyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.SchemaExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-manager/overview/"))
public class SchemaExchangeResource {
    private final SchemaExchangeRESTServices restAPI = new SchemaExchangeRESTServices();

    @PostMapping(path={"/schema-types"})
    public GUIDResponse createSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="null") String anchorGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.createSchemaType(serverName, userId, assetManagerIsHome, anchorGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-types/from-template/{templateGUID}"})
    public GUIDResponse createSchemaTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaTypeFromTemplate(serverName, userId, templateGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}"})
    public VoidResponse updateSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.updateSchemaType(serverName, userId, schemaTypeGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementGUID}/{parentElementTypeName}/schema-types/{schemaTypeGUID}"})
    public VoidResponse setupSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @PathVariable String schemaTypeGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupSchemaTypeParent(serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementGUID}/{parentElementTypeName}/schema-types/{schemaTypeGUID}/remove"})
    public VoidResponse clearSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @PathVariable String schemaTypeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearSchemaTypeParent(serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-elements/{endOneGUID}/relationships/{relationshipTypeName}/schema-elements/{endTwoGUID}"})
    public VoidResponse setupSchemaElementRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endOneGUID, @PathVariable String relationshipTypeName, @PathVariable String endTwoGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupSchemaElementRelationship(serverName, userId, endOneGUID, relationshipTypeName, endTwoGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-elements/{endOneGUID}/relationships/{relationshipTypeName}/schema-elements/{endTwoGUID}/remove"})
    public VoidResponse clearSchemaElementRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endOneGUID, @PathVariable String relationshipTypeName, @PathVariable String endTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearSchemaElementRelationship(serverName, userId, endOneGUID, relationshipTypeName, endTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}/remove"})
    public VoidResponse removeSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeSchemaType(serverName, userId, schemaTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-types/by-search-string"})
    public SchemaTypeElementsResponse findSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSchemaType(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementTypeName}/{parentElementGUID}/schema-types/retrieve"})
    public SchemaTypeElementResponse getSchemaTypeForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaTypeForElement(serverName, userId, parentElementGUID, parentElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-types/by-name"})
    public SchemaTypeElementsResponse getSchemaTypeByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getSchemaTypeByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}/retrieve"})
    public SchemaTypeElementResponse getSchemaTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaTypeByGUID(serverName, userId, schemaTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/parents/schema-types/{schemaTypeGUID}/retrieve"})
    public ElementHeaderResponse getSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaTypeParent(serverName, userId, schemaTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/schema-attributes"})
    public GUIDResponse createSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SchemaAttributeRequestBody requestBody) {
        return this.restAPI.createSchemaAttribute(serverName, userId, schemaElementGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/schema-attributes/from-template/{templateGUID}"})
    public GUIDResponse createSchemaAttributeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaAttributeFromTemplate(serverName, userId, schemaElementGUID, templateGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}"})
    public VoidResponse updateSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SchemaAttributeRequestBody requestBody) {
        return this.restAPI.updateSchemaAttribute(serverName, userId, schemaAttributeGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/is-calculated-value"})
    public VoidResponse setSchemaElementAsCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody CalculatedValueClassificationRequestBody requestBody) {
        return this.restAPI.setSchemaElementAsCalculatedValue(serverName, userId, schemaElementGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/is-calculated-value/remove"})
    public VoidResponse clearSchemaElementAsCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.clearSchemaElementAsCalculatedValue(serverName, userId, schemaElementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/is-primary-key"})
    public VoidResponse setupColumnAsPrimaryKey(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody PrimaryKeyClassificationRequestBody requestBody) {
        return this.restAPI.setupColumnAsPrimaryKey(serverName, userId, schemaAttributeGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/is-primary-key/remove"})
    public VoidResponse clearColumnAsPrimaryKey(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.clearColumnAsPrimaryKey(serverName, userId, schemaAttributeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{primaryKeyGUID}/relationships/foreign-keys/{foreignKeyGUID}"})
    public VoidResponse setupForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyGUID, @PathVariable String foreignKeyGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ForeignKeyRequestBody requestBody) {
        return this.restAPI.setupForeignKeyRelationship(serverName, userId, primaryKeyGUID, foreignKeyGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{primaryKeyGUID}/relationships/foreign-keys/{foreignKeyGUID}/update"})
    public VoidResponse updateForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyGUID, @PathVariable String foreignKeyGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ForeignKeyRequestBody requestBody) {
        return this.restAPI.updateForeignKeyRelationship(serverName, userId, primaryKeyGUID, foreignKeyGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{primaryKeyGUID}/relationships/foreign-keys/{foreignKeyGUID}/remove"})
    public VoidResponse clearForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyGUID, @PathVariable String foreignKeyGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearForeignKeyRelationship(serverName, userId, primaryKeyGUID, foreignKeyGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/remove"})
    public VoidResponse removeSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeSchemaAttribute(serverName, userId, schemaAttributeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/by-search-string"})
    public SchemaAttributeElementsResponse findSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSchemaAttributes(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-elements/{parentSchemaElementGUID}/schema-attributes/retrieve"})
    public SchemaAttributeElementsResponse getNestedAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentSchemaElementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNestedAttributes(serverName, userId, parentSchemaElementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/by-name"})
    public SchemaAttributeElementsResponse getSchemaAttributesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getSchemaAttributesByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/retrieve"})
    public SchemaAttributeElementResponse getSchemaAttributeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaAttributeByGUID(serverName, userId, schemaAttributeGUID, forLineage, forDuplicateProcessing, requestBody);
    }
}

