/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.AssetManagerProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-manager/overview"))
public class AssetManagerOMASResource {
    private final AssetManagerRESTServices restAPI = new AssetManagerRESTServices();

    @GetMapping(path={"/description"})
    public RegisteredOMAGServiceResponse getServiceDescription(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getServiceDescription(serverName, userId);
    }

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public OCFConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/asset-managers"})
    public GUIDResponse createExternalAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestBody AssetManagerProperties assetManagerProperties) {
        return this.restAPI.createExternalAssetManager(serverName, userId, assetManagerProperties);
    }

    @GetMapping(path={"/asset-managers/by-name/{qualifiedName}"})
    public GUIDResponse getExternalAssetManagerGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getExternalAssetManagerGUID(serverName, userId, qualifiedName);
    }
}

