/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.LineageExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-manager/overview"))
public class LineageExchangeResource {
    private final LineageExchangeRESTServices restAPI = new LineageExchangeRESTServices();

    @PostMapping(path={"/processes"})
    public GUIDResponse createProcess(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody ProcessRequestBody requestBody) {
        return this.restAPI.createProcess(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/processes/from-template/{templateGUID}"})
    public GUIDResponse createProcessFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createProcessFromTemplate(serverName, userId, assetManagerIsHome, templateGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}"})
    public VoidResponse updateProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ProcessRequestBody requestBody) {
        return this.restAPI.updateProcess(serverName, userId, processGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/status"})
    public VoidResponse updateProcessStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ProcessStatusRequestBody requestBody) {
        return this.restAPI.updateProcessStatus(serverName, userId, processGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/parent/{parentProcessGUID}/child/{childProcessGUID}"})
    public VoidResponse setupProcessParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentProcessGUID, @PathVariable String childProcessGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupProcessParent(serverName, userId, parentProcessGUID, childProcessGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/parent/{parentProcessGUID}/child/{childProcessGUID}/remove"})
    public VoidResponse clearProcessParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentProcessGUID, @PathVariable String childProcessGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearProcessParent(serverName, userId, parentProcessGUID, childProcessGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/publish"})
    public VoidResponse publishProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.publishProcess(serverName, userId, processGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/withdraw"})
    public VoidResponse withdrawProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.withdrawProcess(serverName, userId, processGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/remove"})
    public VoidResponse removeProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeProcess(serverName, userId, processGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/by-search-string"})
    public ProcessElementsResponse findProcesses(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findProcesses(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/by-asset-manager"})
    public ProcessElementsResponse getProcessesForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getProcessesForAssetManager(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/by-name"})
    public ProcessElementsResponse getProcessesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getProcessesByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/retrieve"})
    public ProcessElementResponse getProcessByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getProcessByGUID(serverName, userId, processGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/parent/retrieve"})
    public ProcessElementResponse getProcessParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getProcessParent(serverName, userId, processGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/children/retrieve"})
    public ProcessElementsResponse getSubProcesses(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSubProcesses(serverName, userId, processGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports"})
    public GUIDResponse createPort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody PortRequestBody requestBody) {
        return this.restAPI.createPort(serverName, userId, assetManagerIsHome, processGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/update"})
    public VoidResponse updatePort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody PortRequestBody requestBody) {
        return this.restAPI.updatePort(serverName, userId, portGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports/{portGUID}"})
    public VoidResponse setupProcessPort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @PathVariable String portGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupProcessPort(serverName, userId, assetManagerIsHome, processGUID, portGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports/{portGUID}/remove"})
    public VoidResponse clearProcessPort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @PathVariable String portGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearProcessPort(serverName, userId, processGUID, portGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portOneGUID}/port-delegations/{portTwoGUID}"})
    public VoidResponse setupPortDelegation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portOneGUID, @PathVariable String portTwoGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupPortDelegation(serverName, userId, assetManagerIsHome, portOneGUID, portTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portOneGUID}/port-delegations/{portTwoGUID}/remove"})
    public VoidResponse clearPortDelegation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portOneGUID, @PathVariable String portTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearPortDelegation(serverName, userId, portOneGUID, portTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/schema-type/{schemaTypeGUID}"})
    public VoidResponse setupPortSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @PathVariable String portGUID, @PathVariable String schemaTypeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupPortSchemaType(serverName, userId, assetManagerIsHome, portGUID, schemaTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/schema-type/{schemaTypeGUID}/remove"})
    public VoidResponse clearPortSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @PathVariable String schemaTypeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearPortSchemaType(serverName, userId, portGUID, schemaTypeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/remove"})
    public VoidResponse removePort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removePort(serverName, userId, portGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/by-search-string"})
    public PortElementsResponse findPorts(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findPorts(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports/retrieve"})
    public PortElementsResponse getPortsForProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getPortsForProcess(serverName, userId, processGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/used-by/retrieve"})
    public PortElementsResponse getPortUse(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getPortUse(serverName, userId, portGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/port-delegations/retrieve"})
    public PortElementResponse getPortDelegation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getPortDelegation(serverName, userId, portGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/by-name"})
    public PortElementsResponse getPortsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getPortsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/retrieve"})
    public PortElementResponse getPortByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getPortByGUID(serverName, userId, portGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/is-business-significant"})
    public VoidResponse setBusinessSignificant(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.setBusinessSignificant(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/is-business-significant/remove"})
    public VoidResponse clearBusinessSignificant(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.clearBusinessSignificant(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/{dataConsumerGUID}"})
    public GUIDResponse setupDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @PathVariable String dataConsumerGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupDataFlow(serverName, userId, dataSupplierGUID, dataConsumerGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/{dataConsumerGUID}/retrieve"})
    public DataFlowElementResponse getDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @PathVariable String dataConsumerGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.getDataFlow(serverName, userId, dataSupplierGUID, dataConsumerGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-flows/{dataFlowGUID}/update"})
    public VoidResponse updateDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFlowGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.updateDataFlow(serverName, userId, dataFlowGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-flows/{dataFlowGUID}/remove"})
    public VoidResponse clearDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFlowGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearDataFlow(serverName, userId, dataFlowGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/retrieve"})
    public DataFlowElementsResponse getDataFlowConsumers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getDataFlowConsumers(serverName, userId, dataSupplierGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/data-flows/consumers/{dataConsumerGUID}/suppliers/retrieve"})
    public DataFlowElementsResponse getDataFlowSuppliers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataConsumerGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getDataFlowSuppliers(serverName, userId, dataConsumerGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/{nextStepGUID}"})
    public GUIDResponse setupControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @PathVariable String nextStepGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupControlFlow(serverName, userId, currentStepGUID, nextStepGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/{nextStepGUID}/retrieve"})
    public ControlFlowElementResponse getControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @PathVariable String nextStepGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.getControlFlow(serverName, userId, currentStepGUID, nextStepGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/control-flows/{controlFlowGUID}/update"})
    public VoidResponse updateControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String controlFlowGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.updateControlFlow(serverName, userId, controlFlowGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/control-flows/{controlFlowGUID}/remove"})
    public VoidResponse clearControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String controlFlowGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearControlFlow(serverName, userId, controlFlowGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/retrieve"})
    public ControlFlowElementsResponse getControlFlowNextSteps(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getControlFlowNextSteps(serverName, userId, currentStepGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/previous-steps/retrieve"})
    public ControlFlowElementsResponse getControlFlowPreviousSteps(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getControlFlowPreviousSteps(serverName, userId, currentStepGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/{calledGUID}"})
    public GUIDResponse setupProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @PathVariable String calledGUID, @RequestParam boolean assetManagerIsHome, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupProcessCall(serverName, userId, callerGUID, calledGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/{calledGUID}/retrieve"})
    public ProcessCallElementResponse getProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @PathVariable String calledGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.getProcessCall(serverName, userId, callerGUID, calledGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/process-calls/{processCallGUID}/update"})
    public VoidResponse updateProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processCallGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.updateProcessCall(serverName, userId, processCallGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/process-calls/{processCallGUID}/remove"})
    public VoidResponse clearProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processCallGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearProcessCall(serverName, userId, processCallGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/retrieve"})
    public ProcessCallElementsResponse getProcessCalled(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getProcessCalled(serverName, userId, callerGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/process-calls/called/{calledGUID}/callers/retrieve"})
    public ProcessCallElementsResponse getProcessCallers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String calledGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getProcessCallers(serverName, userId, calledGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/{destinationElementGUID}"})
    public GUIDResponse setupLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @PathVariable String destinationElementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupLineageMapping(serverName, userId, sourceElementGUID, destinationElementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/{destinationElementGUID}/retrieve"})
    public LineageMappingElementResponse getLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @PathVariable String destinationElementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.getLineageMapping(serverName, userId, sourceElementGUID, destinationElementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/{lineageMappingGUID}/update"})
    public VoidResponse updateLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String lineageMappingGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.updateLineageMapping(serverName, userId, lineageMappingGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/{lineageMappingGUID}/remove"})
    public VoidResponse clearLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String lineageMappingGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearLineageMapping(serverName, userId, lineageMappingGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/retrieve"})
    public LineageMappingElementsResponse getDestinationLineageMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getDestinationLineageMappings(serverName, userId, sourceElementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/destinations/{destinationElementGUID}/sources/retrieve"})
    public LineageMappingElementsResponse getSourceLineageMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String destinationElementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSourceLineageMappings(serverName, userId, destinationElementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }
}

