/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventInterface;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetmanager.ffdc.AssetManagerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetManagerOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements AssetManagerEventInterface {
    private static final Logger log = LoggerFactory.getLogger(AssetManagerOutTopicClientConnector.class);
    private List<AssetManagerEventListener> internalEventListeners = new ArrayList<AssetManagerEventListener>();

    public synchronized void registerListener(String userId, AssetManagerEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(AssetManagerErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                AssetManagerOutTopicEvent eventObject = (AssetManagerOutTopicEvent)super.getEventBean(event, AssetManagerOutTopicEvent.class);
                for (AssetManagerEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

