/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetOwnerElementHeader;
import org.odpi.openmetadata.accessservices.assetowner.properties.Classification;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Asset
extends AssetOwnerElementHeader {
    private String url = null;
    private String guid = null;
    private String typeId = null;
    private String typeName = null;
    private long typeVersion = 0L;
    private String typeDescription = null;
    private String qualifiedName = null;
    private String displayName = null;
    private String description = null;
    private String owner = null;
    private Map<String, Object> additionalProperties = null;
    private List<Classification> classifications = null;

    public Asset() {
    }

    public Asset(Asset template) {
        super(template);
        if (template != null) {
            this.url = template.getURL();
            this.guid = template.getGUID();
            this.typeId = template.getTypeId();
            this.typeName = template.getTypeName();
            this.typeVersion = template.getTypeVersion();
            this.typeDescription = template.getTypeDescription();
            this.qualifiedName = template.getQualifiedName();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.additionalProperties = template.getAdditionalProperties();
            this.classifications = template.getClassifications();
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public long getTypeVersion() {
        return this.typeVersion;
    }

    public void setTypeVersion(long typeVersion) {
        this.typeVersion = typeVersion;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Map<String, Object> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public List<Classification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return this.classifications;
    }

    public void setClassifications(List<Classification> classifications) {
        this.classifications = classifications;
    }

    public String toString() {
        return "Asset{url='" + this.url + '\'' + ", guid='" + this.guid + '\'' + ", typeId='" + this.typeId + '\'' + ", typeName='" + this.typeName + '\'' + ", typeVersion=" + this.typeVersion + ", typeDescription='" + this.typeDescription + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", additionalProperties='" + this.additionalProperties + '\'' + ", classifications='" + this.classifications + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        return this.getTypeVersion() == asset.getTypeVersion() && Objects.equals(this.getURL(), asset.getURL()) && Objects.equals(this.getGUID(), asset.getGUID()) && Objects.equals(this.getTypeId(), asset.getTypeId()) && Objects.equals(this.getTypeName(), asset.getTypeName()) && Objects.equals(this.getTypeDescription(), asset.getTypeDescription()) && Objects.equals(this.getQualifiedName(), asset.getQualifiedName()) && Objects.equals(this.getDisplayName(), asset.getDisplayName()) && Objects.equals(this.getDescription(), asset.getDescription()) && Objects.equals(this.getOwner(), asset.getOwner()) && Objects.equals(this.getAdditionalProperties(), asset.getAdditionalProperties()) && Objects.equals(this.getClassifications(), asset.getClassifications());
    }

    public int hashCode() {
        return Objects.hash(this.getURL(), this.getGUID(), this.getTypeId(), this.getTypeName(), this.getTypeVersion(), this.getTypeDescription(), this.getQualifiedName(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.getAdditionalProperties(), this.getClassifications());
    }
}

