/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.events.AssetOwnerEventHeader;
import org.odpi.openmetadata.accessservices.assetowner.events.AssetOwnerEventType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetOwnerEvent
extends AssetOwnerEventHeader {
    private AssetOwnerEventType eventType = null;
    private Asset originalAsset = null;
    private Asset asset = null;

    public AssetOwnerEvent() {
    }

    public AssetOwnerEvent(AssetOwnerEvent template) {
        super(template);
        if (template != null) {
            this.eventType = template.getEventType();
            this.asset = template.getAsset();
            this.originalAsset = template.getOriginalAsset();
        }
    }

    public AssetOwnerEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(AssetOwnerEventType eventType) {
        this.eventType = eventType;
    }

    public Asset getOriginalAsset() {
        return this.originalAsset;
    }

    public void setOriginalAsset(Asset originalAsset) {
        this.originalAsset = originalAsset;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public String toString() {
        return "AssetOwnerEvent{eventType=" + this.eventType + ", originalAsset=" + this.originalAsset + ", asset=" + this.asset + ", eventVersionId=" + this.getEventVersionId() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetOwnerEvent)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetOwnerEvent that = (AssetOwnerEvent)objectToCompare;
        return this.getEventType() == that.getEventType() && Objects.equals(this.getOriginalAsset(), that.getOriginalAsset()) && Objects.equals(this.getAsset(), that.getAsset());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEventType(), this.getOriginalAsset(), this.getAsset());
    }
}

