/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaImplementationQuery;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DerivedSchemaAttributeProperties
extends SchemaAttributeProperties {
    private static final long serialVersionUID = 1L;
    protected String formula = null;
    protected List<SchemaImplementationQuery> queries = null;

    public DerivedSchemaAttributeProperties() {
    }

    public DerivedSchemaAttributeProperties(DerivedSchemaAttributeProperties template) {
        super(template);
        if (template != null) {
            this.formula = template.getFormula();
            this.queries = template.getQueries();
        }
    }

    public DerivedSchemaAttribute cloneProperties(DerivedSchemaAttribute objectToFill) {
        DerivedSchemaAttribute clone = objectToFill;
        if (clone == null) {
            clone = new DerivedSchemaAttribute();
        }
        clone.setFormula(this.getFormula());
        clone.setQueries(this.getQueries());
        super.cloneProperties((SchemaAttribute)clone);
        return clone;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public List<SchemaImplementationQuery> getQueries() {
        if (this.queries == null) {
            return null;
        }
        if (this.queries.isEmpty()) {
            return null;
        }
        return new ArrayList<SchemaImplementationQuery>(this.queries);
    }

    public void setQueries(List<SchemaImplementationQuery> queries) {
        this.queries = queries;
    }

    @Override
    public String toString() {
        return "DerivedSchemaAttributeProperties{formula='" + this.formula + '\'' + ", queries=" + this.queries + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", deprecated=" + this.isDeprecated() + ", typeName='" + this.getTypeName() + '\'' + ", classifications=" + this.getClassifications() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DerivedSchemaAttributeProperties that = (DerivedSchemaAttributeProperties)objectToCompare;
        return Objects.equals(this.formula, that.formula) && Objects.equals(this.queries, that.queries);
    }
}

