/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum AssetOwnerAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-ASSET-OWNER-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Owner Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Owner OMAS.  This service enables tools to capture information about assets, build a catalog and set up information about how these assets should be governed.", "No action is required if this service is expected to be started in this server.  If this service is not required then it can be removed from the access service list in the configuration document for this server.  It will then not be started the next time the server starts up."),
    SERVICE_INITIALIZED("OMAS-ASSET-OWNER-0003", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Owner Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that this service has initialized successfully and has the correct set of supported zones and default zones defined.  Investigate any reported errors.  Also ensure that theenterprise repository services and the OCF metadata management services are initialized."),
    SERVICE_SHUTDOWN("OMAS-ASSET-OWNER-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Owner Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Asset Owner OMAS instance.", "No action is required if this shutdown was intended."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-OWNER-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The Asset Owner Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private static final long serialVersionUID = 1L;
    private AuditLogMessageDefinition messageDefinition;

    private AssetOwnerAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "AssetOwnerAuditCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

