/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SchemaTypeProperties.class, name="SchemaTypeProperties"), @JsonSubTypes.Type(value=SchemaAttributeProperties.class, name="SchemaAttributeProperties")})
public abstract class SchemaElementProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    private String description = null;
    private boolean isDeprecated = false;

    public SchemaElementProperties() {
    }

    public SchemaElementProperties(SchemaElementProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.isDeprecated = template.isDeprecated();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    @Override
    public String toString() {
        return "SchemaElementProperties{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", isDeprecated=" + this.isDeprecated + ", typeName='" + this.getTypeName() + '\'' + ", classifications=" + this.getClassifications() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        SchemaElementProperties that = (SchemaElementProperties)objectToCompare;
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getDisplayName(), this.getDescription());
    }
}

