/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ElementOrigin;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ElementType;
import org.odpi.openmetadata.accessservices.assetowner.properties.ElementClassification;
import org.odpi.openmetadata.accessservices.assetowner.properties.MeaningProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SecurityTagsProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private ElementType type = null;
    private ElementOrigin origin = null;
    private List<ElementClassification> classifications = null;
    private List<MeaningProperties> meanings = null;
    private SecurityTagsProperties securityTags = null;

    public ElementHeader() {
    }

    public ElementHeader(ElementHeader template) {
        if (template != null) {
            this.guid = template.getGUID();
            this.type = template.getType();
            this.origin = template.getOrigin();
            this.classifications = template.getClassifications();
            this.meanings = template.getMeanings();
            this.securityTags = template.getSecurityTags();
        }
    }

    public ElementType getType() {
        if (this.type == null) {
            return null;
        }
        return this.type;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public ElementOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(ElementOrigin origin) {
        this.origin = origin;
    }

    public List<ElementClassification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<ElementClassification>(this.classifications);
    }

    public void setClassifications(List<ElementClassification> classifications) {
        this.classifications = classifications;
    }

    public List<MeaningProperties> getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        if (this.meanings.isEmpty()) {
            return null;
        }
        return new ArrayList<MeaningProperties>(this.meanings);
    }

    public void setMeanings(List<MeaningProperties> meanings) {
        this.meanings = meanings;
    }

    public SecurityTagsProperties getSecurityTags() {
        return this.securityTags;
    }

    public void setSecurityTags(SecurityTagsProperties securityTags) {
        this.securityTags = securityTags;
    }

    public String toString() {
        return "ElementHeader{guid='" + this.guid + '\'' + ", type=" + this.type + ", origin=" + this.origin + ", classifications=" + this.classifications + ", meanings=" + this.meanings + ", securityTags=" + this.securityTags + ", GUID='" + this.getGUID() + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ElementHeader that = (ElementHeader)objectToCompare;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.type, that.type) && Objects.equals(this.origin, that.origin) && Objects.equals(this.classifications, that.classifications) && Objects.equals(this.meanings, that.meanings) && Objects.equals(this.securityTags, that.securityTags);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.type, this.origin, this.classifications, this.meanings, this.securityTags);
    }
}

