/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetOwnerOMASAPIRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OriginRequestBody
extends AssetOwnerOMASAPIRequestBody {
    private static final long serialVersionUID = 1L;
    private String organizationGUID = null;
    private String businessCapabilityGUID = null;
    private Map<String, String> otherOriginValues = null;

    public OriginRequestBody() {
    }

    public OriginRequestBody(OriginRequestBody template) {
        super(template);
        if (template != null) {
            this.organizationGUID = template.getOrganizationGUID();
            this.businessCapabilityGUID = template.getBusinessCapabilityGUID();
            this.otherOriginValues = template.getOtherOriginValues();
        }
    }

    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    public String getBusinessCapabilityGUID() {
        return this.businessCapabilityGUID;
    }

    public void setBusinessCapabilityGUID(String businessCapabilityGUID) {
        this.businessCapabilityGUID = businessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        if (this.otherOriginValues == null) {
            return null;
        }
        if (this.otherOriginValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.otherOriginValues);
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    @Override
    public String toString() {
        return "OriginRequestBody{organizationGUID='" + this.organizationGUID + '\'' + ", businessCapabilityGUID='" + this.businessCapabilityGUID + '\'' + ", otherOriginValues=" + this.otherOriginValues + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OriginRequestBody that = (OriginRequestBody)objectToCompare;
        return Objects.equals(this.getOrganizationGUID(), that.getOrganizationGUID()) && Objects.equals(this.getBusinessCapabilityGUID(), that.getBusinessCapabilityGUID()) && Objects.equals(this.getOtherOriginValues(), that.getOtherOriginValues());
    }

    public int hashCode() {
        return Objects.hash(this.getOrganizationGUID(), this.getBusinessCapabilityGUID(), this.getOtherOriginValues());
    }
}

