/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareServerCapability;

public class FileSystem
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private static String FILE_SYSTEM_CLASSIFICATION_NAME = "FileSystem";
    private static String FORMAT_PROPERTY_NAME = "format";
    private static String ENCRYPTION_PROPERTY_NAME = "encryption";
    private String fileSystemType = null;
    private String version = null;
    private String patchLevel = null;
    private String source = null;
    private String format = null;
    private String encryption = null;

    public FileSystem() {
    }

    public FileSystem(FileSystem template) {
        super(template);
        if (template != null) {
            this.fileSystemType = template.getFileSystemType();
            this.version = template.getVersion();
            this.patchLevel = template.getPatchLevel();
            this.source = template.getSource();
            this.format = template.getFormat();
            this.encryption = template.getEncryption();
        }
    }

    public FileSystem(SoftwareServerCapability template) {
        super((Referenceable)template);
        if (template != null) {
            this.fileSystemType = template.getTypeDescription();
            this.version = template.getVersion();
            this.patchLevel = template.getPatchLevel();
            this.source = template.getSource();
            List classifications = template.getClassifications();
            if (classifications != null) {
                for (Classification classification : classifications) {
                    Map properties;
                    if (classification == null || !FILE_SYSTEM_CLASSIFICATION_NAME.equals(classification.getClassificationName()) || (properties = classification.getClassificationProperties()) == null) continue;
                    this.format = properties.get(FORMAT_PROPERTY_NAME).toString();
                    this.encryption = properties.get(ENCRYPTION_PROPERTY_NAME).toString();
                }
            }
        }
    }

    public String getFileSystemType() {
        return this.fileSystemType;
    }

    public void setFileSystemType(String type) {
        this.fileSystemType = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPatchLevel() {
        return this.patchLevel;
    }

    public void setPatchLevel(String patchLevel) {
        this.patchLevel = patchLevel;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    @Override
    public String toString() {
        return "FileSystem{fileSystemType='" + this.fileSystemType + '\'' + ", version='" + this.version + '\'' + ", patchLevel='" + this.patchLevel + '\'' + ", source='" + this.source + '\'' + ", format='" + this.format + '\'' + ", encryption='" + this.encryption + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", classifications=" + this.getClassifications() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        FileSystem that = (FileSystem)objectToCompare;
        return Objects.equals(this.getFileSystemType(), that.getFileSystemType()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getPatchLevel(), that.getPatchLevel()) && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(this.getFormat(), that.getFormat()) && Objects.equals(this.getEncryption(), that.getEncryption());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFileSystemType(), this.getVersion(), this.getPatchLevel(), this.getSource(), this.getFormat(), this.getEncryption());
    }
}

