/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.properties.ElementClassification;
import org.odpi.openmetadata.accessservices.assetowner.properties.MeaningProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetOwnerOMASAPIRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValuesRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ValidValuesRequestBody.class, name="ValidValuesRequestBody")})
public class ReferenceableRequestBody
extends AssetOwnerOMASAPIRequestBody {
    private static final long serialVersionUID = 1L;
    protected String typeName = null;
    protected List<ElementClassification> classifications = null;
    protected String qualifiedName = null;
    protected List<MeaningProperties> meanings = null;
    protected Map<String, String> additionalProperties = null;
    protected Map<String, Object> extendedProperties = null;

    public ReferenceableRequestBody() {
    }

    public ReferenceableRequestBody(ReferenceableRequestBody template) {
        super(template);
        if (template != null) {
            this.typeName = template.getTypeName();
            this.classifications = template.getClassifications();
            this.qualifiedName = template.getQualifiedName();
            this.meanings = template.getMeanings();
            this.additionalProperties = template.getAdditionalProperties();
            this.extendedProperties = template.getExtendedProperties();
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public List<ElementClassification> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<ElementClassification> classifications) {
        this.classifications = classifications;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalProperties);
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public List<MeaningProperties> getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        if (this.meanings.isEmpty()) {
            return null;
        }
        return new ArrayList<MeaningProperties>(this.meanings);
    }

    public void setMeanings(List<MeaningProperties> meanings) {
        this.meanings = meanings;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            return null;
        }
        if (this.extendedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.extendedProperties);
    }

    public void setExtendedProperties(Map<String, Object> extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    @Override
    public String toString() {
        return "ReferenceableRequestBody{typeName='" + this.typeName + '\'' + ", classifications=" + this.classifications + ", qualifiedName='" + this.qualifiedName + '\'' + ", meanings=" + this.meanings + ", additionalProperties=" + this.additionalProperties + ", extendedProperties=" + this.extendedProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ReferenceableRequestBody that = (ReferenceableRequestBody)objectToCompare;
        return Objects.equals(this.getTypeName(), that.getTypeName()) && Objects.equals(this.getClassifications(), that.getClassifications()) && Objects.equals(this.getQualifiedName(), that.getQualifiedName()) && Objects.equals(this.getMeanings(), that.getMeanings()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties()) && Objects.equals(this.getExtendedProperties(), that.getExtendedProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getTypeName(), this.getClassifications(), this.getQualifiedName(), this.getMeanings(), this.getAdditionalProperties(), this.getExtendedProperties());
    }
}

