/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CommentType {
    STANDARD_COMMENT(0, 0, "Comment", "General comment about the element."),
    QUESTION(1, 1, "Question", "Asks a question to the people owning, managing or using the element."),
    ANSWER(2, 2, "Answer", "Answers a question (posted as a reply to the question)."),
    SUGGESTION(3, 3, "Suggestion", "Provides a suggestion on how to improve the element or its properties and description."),
    USAGE_EXPERIENCE(4, 4, "Experience", "Describes situations where this asset has been used and related hints and tips."),
    OTHER(99, 99, "Other", "Unknown comment type.");

    private static final String ENUM_TYPE_GUID = "06d5032e-192a-4f77-ade1-a4b97926e867";
    private static final String ENUM_TYPE_NAME = "CommentType";
    private final int openTypeOrdinal;
    private final int ordinal;
    private final String name;
    private final String description;

    private CommentType(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "CommentType{commentTypeCode=" + this.ordinal + ", commentType='" + this.name + "', commentTypeDescription='" + this.description + "'}";
    }
}

