/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.properties.DataStoreProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.OwnerType;
import org.odpi.openmetadata.accessservices.assetowner.properties.SupplementaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataStoreProperties.class, name="DataStoreProperties")})
public class AssetProperties
extends SupplementaryProperties {
    private String name = null;
    private String versionIdentifier = null;
    private String description = null;
    private String owner = null;
    private OwnerType ownerType = null;
    private String ownerTypeName = null;
    private String ownerPropertyName = null;
    private List<String> zoneMembership = null;
    private String originOrganizationGUID = null;
    private String originBusinessCapabilityGUID = null;
    private Map<String, String> otherOriginValues = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.versionIdentifier = template.getVersionIdentifier();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.ownerTypeName = template.getOwnerTypeName();
            this.ownerPropertyName = template.getOwnerPropertyName();
            this.ownerType = template.getOwnerType();
            this.zoneMembership = template.getZoneMembership();
            this.originOrganizationGUID = template.getOriginOrganizationGUID();
            this.originBusinessCapabilityGUID = template.getOriginBusinessCapabilityGUID();
            this.otherOriginValues = template.getOtherOriginValues();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerTypeName() {
        return this.ownerTypeName;
    }

    public void setOwnerTypeName(String ownerTypeName) {
        this.ownerTypeName = ownerTypeName;
    }

    public String getOwnerPropertyName() {
        return this.ownerPropertyName;
    }

    public void setOwnerPropertyName(String ownerPropertyName) {
        this.ownerPropertyName = ownerPropertyName;
    }

    @Deprecated
    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Deprecated
    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getOriginOrganizationGUID() {
        return this.originOrganizationGUID;
    }

    public void setOriginOrganizationGUID(String originOrganizationGUID) {
        this.originOrganizationGUID = originOrganizationGUID;
    }

    public String getOriginBusinessCapabilityGUID() {
        return this.originBusinessCapabilityGUID;
    }

    public void setOriginBusinessCapabilityGUID(String originBusinessCapabilityGUID) {
        this.originBusinessCapabilityGUID = originBusinessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        if (this.otherOriginValues == null) {
            return null;
        }
        if (this.otherOriginValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.otherOriginValues);
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    @Override
    public String toString() {
        return "AssetProperties{name='" + this.name + "', versionIdentifier='" + this.versionIdentifier + "', description='" + this.description + "', owner='" + this.owner + "', ownerType=" + this.ownerType + ", ownerTypeName='" + this.ownerTypeName + "', ownerPropertyName='" + this.ownerPropertyName + "', zoneMembership=" + this.zoneMembership + ", originOrganizationGUID='" + this.originOrganizationGUID + "', originBusinessCapabilityGUID='" + this.originBusinessCapabilityGUID + "', otherOriginValues=" + this.otherOriginValues + ", typeName='" + this.getTypeName() + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + ", displayName='" + this.getDisplayName() + "', displaySummary='" + this.getDisplaySummary() + "', displayDescription='" + this.getDisplayDescription() + "', abbreviation='" + this.getAbbreviation() + "', usage='" + this.getUsage() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.versionIdentifier != null ? !this.versionIdentifier.equals(that.versionIdentifier) : that.versionIdentifier != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.ownerType != that.ownerType) {
            return false;
        }
        if (this.ownerTypeName != null ? !this.ownerTypeName.equals(that.ownerTypeName) : that.ownerTypeName != null) {
            return false;
        }
        if (this.ownerPropertyName != null ? !this.ownerPropertyName.equals(that.ownerPropertyName) : that.ownerPropertyName != null) {
            return false;
        }
        if (this.zoneMembership != null ? !this.zoneMembership.equals(that.zoneMembership) : that.zoneMembership != null) {
            return false;
        }
        if (this.originOrganizationGUID != null ? !this.originOrganizationGUID.equals(that.originOrganizationGUID) : that.originOrganizationGUID != null) {
            return false;
        }
        if (this.originBusinessCapabilityGUID != null ? !this.originBusinessCapabilityGUID.equals(that.originBusinessCapabilityGUID) : that.originBusinessCapabilityGUID != null) {
            return false;
        }
        return this.otherOriginValues != null ? this.otherOriginValues.equals(that.otherOriginValues) : that.otherOriginValues == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.versionIdentifier, this.description, this.owner, this.ownerTypeName, this.ownerPropertyName, this.ownerType, this.zoneMembership, this.originOrganizationGUID, this.originBusinessCapabilityGUID, this.otherOriginValues);
    }
}

