/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CollectionMembershipStatus {
    UNKNOWN(0, 0, "Unknown", "The membership origin is unknown."),
    DISCOVERED(1, 1, "Discovered", "The membership was discovered by an automated process."),
    ASSIGNED(2, 2, "Assigned", "The membership was proposed by an expert curator."),
    IMPORTED(3, 3, "Imported", "The membership was imported from another metadata system."),
    VALIDATED(4, 4, "Validated", "The membership created by an automated process has been validated and approved by an expert curator."),
    DEPRECATED(5, 5, "Deprecated", "The membership should no longer be used."),
    OBSOLETE(6, 6, "Obsolete", "The membership must no longer be used."),
    OTHER(7, 99, "Other", "Another membership status. See userDefinedStatus.");

    private final int ordinal;
    private final int openMetadataOrdinal;
    private final String name;
    private final String description;

    private CollectionMembershipStatus(int ordinal, int openMetadataOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openMetadataOrdinal = openMetadataOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getOpenMetadataOrdinal() {
        return this.openMetadataOrdinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "CollectionMembershipStatus : " + this.name;
    }
}

