/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GlossaryTermStatus {
    DRAFT(1, 1, "Draft", "The term is incomplete."),
    PREPARED(2, 2, "Prepared", "The term is ready for review."),
    PROPOSED(3, 3, "Proposed", "The term is in review."),
    APPROVED(4, 4, "Approved", "The term is approved and ready to be activated."),
    REJECTED(5, 5, "Rejected", "The term is rejected and should not be used."),
    ACTIVE(6, 15, "Active", "The term is approved and in use."),
    DEPRECATED(7, 30, "Deprecated", "The term is out of date and should not be used."),
    OTHER(8, 50, "Other", "The term is in a locally defined state.");

    private final int ordinal;
    private final int openTypeOrdinal;
    private final String name;
    private final String description;
    private static final long serialVersionUID = 1L;

    private GlossaryTermStatus(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "GlossaryTermStatus{ordinal=" + this.ordinal + ", openTypeOrdinal=" + this.openTypeOrdinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

