/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum AssetOwnerAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-ASSET-OWNER-0001", AuditLogRecordSeverityLevel.STARTUP, "The Asset Owner Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Owner OMAS.  This service enables tools to capture information about assets, build a catalog and set up information about how these assets should be governed.", "No action is required if this service is expected to be started in this server.  If this service is not required then it can be removed from the access service list in the configuration document for this server.  It will then not be started the next time the server starts up."),
    SERVICE_PUBLISHING("OMAS-ASSET-OWNER-0002", AuditLogRecordSeverityLevel.STARTUP, "The Asset Owner Open Metadata Access Service (OMAS) is ready to publish asset notifications to topic {0}", "The local server has started up the event publisher for the Asset Owner OMAS.  It will begin publishing asset configuration changes to its out topic.", "This is part of the normal start up of the service. Check that there are no errors from the event bus."),
    SERVICE_INITIALIZED("OMAS-ASSET-OWNER-0003", AuditLogRecordSeverityLevel.STARTUP, "The Asset Owner Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that this service has initialized successfully and has the correct set of supported zones and default zones defined.  Investigate any reported errors.  Also ensure that theenterprise repository services and the OCF metadata management services are initialized."),
    SERVICE_SHUTDOWN("OMAS-ASSET-OWNER-0004", AuditLogRecordSeverityLevel.SHUTDOWN, "The Asset Owner Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Asset Owner OMAS instance.", "No action is required if this shutdown was intended."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-OWNER-0005", AuditLogRecordSeverityLevel.EXCEPTION, "The Asset Owner Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    PUBLISHING_SHUTDOWN("OMAS-ASSET-OWNER-0010", AuditLogRecordSeverityLevel.SHUTDOWN, "The Asset Owner Open Metadata Access Service (OMAS) is no longer publishing events to topic {0}", "The local administrator has requested shut down of an Asset Owner OMAS instance.  No more configuration events will be published to the named topic.", "This is part of the normal shutdown of the service.   No action is required if this is serviceshutdown was intentional."),
    PUBLISHING_SHUTDOWN_ERROR("OMAS-ASSET-OWNER-0011", AuditLogRecordSeverityLevel.SHUTDOWN, "The Asset Owner Open Metadata Access Service (OMAS) caught an unexpected {0} exception whilst shutting down the out topic {1}. The error message was: {2}", "The local administrator has requested shut down of an Asset Owner OMAS instance.  No more configuration events will be published to the named topic, although the connection to the event bus may not be released properly.", "This is part of the normal shutdown of the service. However, an exception is not expected at this point unless it is the consequence of a previous error. Review the error message and any other reported failures to determine if this exception needs special attention."),
    OUT_TOPIC_EVENT("OMAS-ASSET-OWNER-0012", AuditLogRecordSeverityLevel.EVENT, "The Asset Owner Open Metadata Access Service (OMAS) has sent event of type: {0}", "The access service sends out asset notifications to ensure connected tools have the most up to-date knowledge about assets.  This audit log message is to create a record of the events that are being published.", "This event indicates that the metadata for an asset has changed.  This my or may not be significant to the receiving tools."),
    PROCESS_EVENT_EXCEPTION("OMAS-ASSET-OWNER-0014", AuditLogRecordSeverityLevel.EXCEPTION, "Event {0} could not be published due to {1} exception with message: {2}", "The system is unable to publish the event to the Asset Owner OMAS's OutTopic.", "Verify the topic configuration and that the event broker is running."),
    OUT_TOPIC_FAILURE("OMAS-ASSET-OWNER-0018", AuditLogRecordSeverityLevel.EXCEPTION, "The Asset Owner Open Metadata Access Service (OMAS) is unable to send an event on its out topic {0}; exception {1} returned error message: {2}", "The access service detected an error during the start up of the out topic.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Check the status of the event bus.  Once this is resolved, restart the server.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private AssetOwnerAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AssetOwnerAuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

