/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetClassificationInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetDecommissioningInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetReviewInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetVisibilityInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.properties.GovernanceZone;
import org.odpi.openmetadata.accessservices.assetowner.rest.ZoneListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ZoneRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ZoneResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OriginRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OwnerRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;

public class AssetOwner
extends ConnectedAssetClientBase
implements AssetOnboardingInterface,
AssetClassificationInterface,
AssetVisibilityInterface,
AssetReviewInterface,
AssetDecommissioningInterface {
    private AssetOwnerRESTClient restClient;
    private static final String serviceURLName = "asset-owner";

    public AssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
    }

    public AssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public String addAssetToCatalog(String userId, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetToCatalog";
        String typeNameParameter = "typeName";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "addAssetToCatalog");
        this.invalidParameterHandler.validateName(typeName, "typeName", "addAssetToCatalog");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "addAssetToCatalog");
        AssetRequestBody requestBody = new AssetRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAssetToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}", requestBody, new Object[]{this.serverName, userId, typeName});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addAssetToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addAssetToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addAssetToCatalog", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public String addSchemaToAsset(String userId, String assetGUID, SchemaType schemaType, List<SchemaAttribute> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaToAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schema-type";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaToAsset");
        SchemaRequestBody requestBody = new SchemaRequestBody();
        requestBody.setSchemaType(schemaType);
        requestBody.setSchemaAttributes(schemaAttributes);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addSchemaToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schema-type", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addSchemaToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addSchemaToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addSchemaToAsset", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public void addSchemaAttributesToSchema(String userId, String schemaTypeGUID, List<SchemaAttribute> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaAttributesToSchema";
        String schemaTypeGUIDParameter = "schemaTypeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schemas/{2}/schema-attributes";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaAttributesToSchema");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "addSchemaAttributesToSchema");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addSchemaAttributesToSchema", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schemas/{2}/schema-attributes", schemaAttributes, new Object[]{this.serverName, userId, schemaTypeGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addSchemaAttributesToSchema", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addSchemaAttributesToSchema", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addSchemaAttributesToSchema", (FFDCResponseBase)restResult);
    }

    public void addConnectionToAsset(String userId, String assetGUID, String assetSummary, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addConnectionToAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connection";
        this.invalidParameterHandler.validateUserId(userId, "addConnectionToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addConnectionToAsset");
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setShortDescription(assetSummary);
        requestBody.setConnection(connection);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addConnectionToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connection", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addConnectionToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addConnectionToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addConnectionToAsset", (FFDCResponseBase)restResult);
    }

    public void addSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSemanticAssignment";
        String assetGUIDParameter = "assetGUID";
        String glossaryTermParameter = "glossaryTermGUID";
        String assetElementParameter = "assetElementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/{3}/elements/{4}";
        this.invalidParameterHandler.validateUserId(userId, "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetElementGUID, "assetElementGUID", "addSemanticAssignment");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/{3}/elements/{4}", this.nullRequestBody, new Object[]{this.serverName, userId, assetGUID, glossaryTermGUID, assetElementGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addSemanticAssignment", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addSemanticAssignment", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addSemanticAssignment", (FFDCResponseBase)restResult);
    }

    public void addAssetOrigin(String userId, String assetGUID, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetOrigin";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin";
        this.invalidParameterHandler.validateUserId(userId, "addAssetOrigin");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addAssetOrigin");
        OriginRequestBody requestBody = new OriginRequestBody();
        requestBody.setBusinessCapabilityGUID(businessCapabilityGUID);
        requestBody.setOrganizationGUID(organizationGUID);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addAssetOrigin", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addAssetOrigin", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addAssetOrigin", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addAssetOrigin", (FFDCResponseBase)restResult);
    }

    public void createGovernanceZone(String userId, String qualifiedName, String displayName, String description, String criteria, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceZone";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/governance-zones";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceZone");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceZone");
        ZoneRequestBody requestBody = new ZoneRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("createGovernanceZone", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/governance-zones", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("createGovernanceZone", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createGovernanceZone", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createGovernanceZone", (FFDCResponseBase)restResult);
    }

    public GovernanceZone getGovernanceZone(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZone";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/governance-zones/name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZone");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getGovernanceZone");
        ZoneResponse restResult = this.restClient.callZoneGetRESTCall("getGovernanceZone", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/governance-zones/name/{2}", this.serverName, userId, qualifiedName);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceZone", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceZone", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceZone", (FFDCResponseBase)restResult);
        return restResult.getGovernanceZone();
    }

    public List<GovernanceZone> getGovernanceZones(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZones";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/governance-zones?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZones");
        ZoneListResponse restResult = this.restClient.callZoneListGetRESTCall("getGovernanceZones", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/governance-zones?startingFrom={4}&maximumResults={5}", this.serverName, userId, Integer.toString(startingFrom), Integer.toString(maximumResults));
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceZones", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceZones", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceZones", (FFDCResponseBase)restResult);
        return restResult.getGovernanceZones();
    }

    public void updateAssetZones(String userId, String assetGUID, List<String> assetZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetZones";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/governance-zones";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetZones");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetZones");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateAssetZones", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/governance-zones", assetZones, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateAssetZones", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateAssetZones", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateAssetZones", (FFDCResponseBase)restResult);
    }

    public void updateAssetOwner(String userId, String assetGUID, String ownerId, OwnerType ownerType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetOwner";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetOwner");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetOwner");
        OwnerRequestBody requestBody = new OwnerRequestBody();
        requestBody.setOwnerId(ownerId);
        requestBody.setOwnerType(ownerType);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateAssetOwner", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateAssetOwner", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateAssetOwner", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateAssetOwner", (FFDCResponseBase)restResult);
    }

    public List<Asset> getAssetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-name?startFrom={2}&pageSize={3}";
        String methodName = "getAssetsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAssetsByName");
        AssetsResponse restResult = this.restClient.callAssetsPostRESTCall("getAssetsByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-name?startFrom={2}&pageSize={3}", name, new Object[]{this.serverName, userId, startFrom, pageSize});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getAssetsByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getAssetsByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getAssetsByName", (FFDCResponseBase)restResult);
        return restResult.getAssets();
    }

    public List<Asset> findAssets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}";
        String methodName = "findAssets";
        String searchParameter = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAssets");
        AssetsResponse restResult = this.restClient.callAssetsPostRESTCall("findAssets", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}", searchString, new Object[]{this.serverName, userId, startFrom, pageSize});
        this.exceptionHandler.detectAndThrowInvalidParameterException("findAssets", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("findAssets", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("findAssets", (FFDCResponseBase)restResult);
        return restResult.getAssets();
    }

    public Asset getAssetSummary(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetSummary";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetSummary");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAssetSummary");
        return super.getAssetSummary((OCFRESTClient)this.restClient, serviceURLName, userId, assetGUID, "getAssetSummary");
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    public Connector getConnectorToAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorToAsset";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectorToAsset");
        try {
            return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, this.getConnectionForAsset((OCFRESTClient)this.restClient, serviceURLName, userId, assetGUID), "getConnectorToAsset");
        }
        catch (ConnectionCheckedException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "connection to asset " + assetGUID);
        }
        catch (ConnectorCheckedException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
    }

    public List<DiscoveryAnalysisReport> getDiscoveryAnalysisReports(String userId, String assetGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryAnalysisReports";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/discovery-analysis-reports?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryAnalysisReports");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getDiscoveryAnalysisReports");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryAnalysisReports");
        DiscoveryAnalysisReportListResponse restResult = this.restClient.callDiscoveryAnalysisReportListGetRESTCall("getDiscoveryAnalysisReports", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/discovery-analysis-reports?startingFrom={4}&maximumResults={5}", new Object[]{this.serverName, userId, assetGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getDiscoveryAnalysisReports", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getDiscoveryAnalysisReports", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getDiscoveryAnalysisReports", (FFDCResponseBase)restResult);
        return restResult.getDiscoveryAnalysisReports();
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryReportAnnotations";
        String discoveryReportGUIDParameter = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/discovery-analysis-reports/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryReportAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getDiscoveryReportAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/discovery-analysis-reports/{2}?startingFrom={3}&maxPageSize={4}", requestBody, new Object[]{this.serverName, userId, discoveryReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getDiscoveryReportAnnotations", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getDiscoveryReportAnnotations", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getDiscoveryReportAnnotations", (FFDCResponseBase)restResult);
        return restResult.getAnnotations();
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameter = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getExtendedAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/{2}?startingFrom={3}&maxPageSize={4}", requestBody, new Object[]{this.serverName, userId, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getExtendedAnnotations", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getExtendedAnnotations", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getExtendedAnnotations", (FFDCResponseBase)restResult);
        return restResult.getAnnotations();
    }

    public void deleteAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "deleteAsset");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/delete", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteAsset", (FFDCResponseBase)restResult);
    }
}

