/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingCSVFileInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewCSVFileAssetRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CSVFileAssetOwner
implements AssetOnboardingCSVFileInterface {
    private String serverName;
    private String serverPlatformRootURL;
    private AssetOwnerRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public CSVFileAssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.addCSVFileToCatalog(userId, displayName, description, fullPath, null, null, null);
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCSVFileToCatalog";
        String pathParameter = "fullPath";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/csv";
        this.invalidParameterHandler.validateUserId(userId, "addCSVFileToCatalog");
        this.invalidParameterHandler.validateName(fullPath, "fullPath", "addCSVFileToCatalog");
        NewCSVFileAssetRequestBody requestBody = new NewCSVFileAssetRequestBody();
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(fullPath);
        requestBody.setColumnHeaders(columnHeaders);
        requestBody.setDelimiterCharacter(delimiterCharacter);
        requestBody.setQuoteCharacter(quoteCharacter);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addCSVFileToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/csv", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addCSVFileToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addCSVFileToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addCSVFileToCatalog", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }
}

