/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingFileSystem;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.properties.FileSystem;
import org.odpi.openmetadata.accessservices.assetowner.properties.Folder;
import org.odpi.openmetadata.accessservices.assetowner.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.FolderResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileSystemRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.PathNameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class FileSystemAssetOwner
implements AssetOnboardingFileSystem {
    private String serverName;
    private String serverPlatformRootURL;
    private AssetOwnerRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public FileSystemAssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
    }

    public FileSystemAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public String createFileSystemInCatalog(String userId, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileSystemInCatalog";
        String pathParameter = "uniqueName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems";
        this.invalidParameterHandler.validateUserId(userId, "createFileSystemInCatalog");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "createFileSystemInCatalog");
        NewFileSystemRequestBody requestBody = new NewFileSystemRequestBody();
        requestBody.setUniqueName(uniqueName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFileSystemType(type);
        requestBody.setVersion(version);
        requestBody.setPatchLevel(patchLevel);
        requestBody.setSource(source);
        requestBody.setFormat(format);
        requestBody.setEncryption(encryption);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileSystemInCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("createFileSystemInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createFileSystemInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createFileSystemInCatalog", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public List<String> createFolderStructureInCatalog(String userId, String anchorGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFolderStructureInCatalog";
        String pathParameter = "pathName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createFolderStructureInCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "createFolderStructureInCatalog");
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("createFolderStructureInCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}", requestBody, new Object[]{this.serverName, userId, anchorGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("createFolderStructureInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createFolderStructureInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createFolderStructureInCatalog", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public List<String> createFolderStructureInCatalog(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFolderStructureInCatalog";
        String pathParameter = "pathName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders";
        this.invalidParameterHandler.validateUserId(userId, "createFolderStructureInCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "createFolderStructureInCatalog");
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("createFolderStructureInCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("createFolderStructureInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createFolderStructureInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createFolderStructureInCatalog", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public void attachFolderToFileSystem(String userId, String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachFolderToFileSystem";
        String fileSystemGUIDParameter = "fileSystemGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}/folders/{3}/attach";
        this.invalidParameterHandler.validateUserId(userId, "attachFolderToFileSystem");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "attachFolderToFileSystem");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachFolderToFileSystem");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("attachFolderToFileSystem", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}/folders/{3}/attach", requestBody, new Object[]{this.serverName, userId, fileSystemGUID, folderGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("attachFolderToFileSystem", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("attachFolderToFileSystem", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("attachFolderToFileSystem", (FFDCResponseBase)restResult);
    }

    public void detachFolderFromFileSystem(String userId, String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachFolderFromFileSystem";
        String fileSystemGUIDParameter = "fileSystemGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}/folders/{3}/detach";
        this.invalidParameterHandler.validateUserId(userId, "detachFolderFromFileSystem");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "detachFolderFromFileSystem");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachFolderFromFileSystem");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("detachFolderFromFileSystem", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}/folders/{3}/detach", requestBody, new Object[]{this.serverName, userId, fileSystemGUID, folderGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("detachFolderFromFileSystem", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("detachFolderFromFileSystem", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("detachFolderFromFileSystem", (FFDCResponseBase)restResult);
    }

    public List<String> addDataFileAssetToCatalog(String userId, String displayName, String description, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFileAssetToCatalog";
        String pathParameter = "pathName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files";
        this.invalidParameterHandler.validateUserId(userId, "addDataFileAssetToCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "addDataFileAssetToCatalog");
        NewFileAssetRequestBody requestBody = new NewFileAssetRequestBody();
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFileAssetToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addDataFileAssetToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addDataFileAssetToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addDataFileAssetToCatalog", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String displayName, String description, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFolderAssetToCatalog";
        String pathParameter = "pathName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-folders";
        this.invalidParameterHandler.validateUserId(userId, "addDataFolderAssetToCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "addDataFolderAssetToCatalog");
        NewFileAssetRequestBody requestBody = new NewFileAssetRequestBody();
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFolderAssetToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-folders", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addDataFolderAssetToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addDataFolderAssetToCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addDataFolderAssetToCatalog", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public void attachDataFileAssetToFolder(String userId, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachDataFileAssetToFolder";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/attach";
        this.invalidParameterHandler.validateUserId(userId, "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachDataFileAssetToFolder");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("attachDataFileAssetToFolder", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/attach", requestBody, new Object[]{this.serverName, userId, folderGUID, fileGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("attachDataFileAssetToFolder", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("attachDataFileAssetToFolder", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("attachDataFileAssetToFolder", (FFDCResponseBase)restResult);
    }

    public void detachDataFileAssetFromFolder(String userId, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachDataFileAssetFromFolder";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/detach";
        this.invalidParameterHandler.validateUserId(userId, "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachDataFileAssetFromFolder");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("detachDataFileAssetFromFolder", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/detach", requestBody, new Object[]{this.serverName, userId, folderGUID, fileGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("detachDataFileAssetFromFolder", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("detachDataFileAssetFromFolder", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("detachDataFileAssetFromFolder", (FFDCResponseBase)restResult);
    }

    public void moveDataFileInCatalog(String userId, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "moveDataFileInCatalog";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/move-to";
        this.invalidParameterHandler.validateUserId(userId, "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "moveDataFileInCatalog");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("moveDataFileInCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/move-to", requestBody, new Object[]{this.serverName, userId, folderGUID, fileGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("moveDataFileInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("moveDataFileInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("moveDataFileInCatalog", (FFDCResponseBase)restResult);
    }

    public void moveDataFolderInCatalog(String userId, String folderGUID, String dataFolderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "moveDataFileInCatalog";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-folders/{3}/move-to";
        this.invalidParameterHandler.validateUserId(userId, "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "fileGUID", "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "moveDataFileInCatalog");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("moveDataFileInCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-folders/{3}/move-to", requestBody, new Object[]{this.serverName, userId, folderGUID, dataFolderGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("moveDataFileInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("moveDataFileInCatalog", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("moveDataFileInCatalog", (FFDCResponseBase)restResult);
    }

    public FileSystem getFileSystemByGUID(String userId, String fileSystemGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByGUID";
        String fileSystemGUIDParameter = "fileSystemGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByGUID");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "getFileSystemByGUID");
        FileSystemResponse restResult = this.restClient.callFileSystemGetRESTCall("getFileSystemByGUID", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}", this.serverName, userId, fileSystemGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getFileSystemByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getFileSystemByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getFileSystemByGUID", (FFDCResponseBase)restResult);
        return restResult.getFileSystem();
    }

    public FileSystem getFileSystemByUniqueName(String userId, String uniqueName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByUniqueName";
        String nameParameter = "uniqueName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getFileSystemByUniqueName");
        FileSystemResponse restResult = this.restClient.callFileSystemGetRESTCall("getFileSystemByUniqueName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/by-name/{2}", this.serverName, userId, uniqueName);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getFileSystemByUniqueName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getFileSystemByUniqueName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getFileSystemByUniqueName", (FFDCResponseBase)restResult);
        return restResult.getFileSystem();
    }

    public List<String> getFileSystems(String userId, int startingFrom, int maxPageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystems";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems?startingFrom={2}&maximumResults={3}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystems");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getFileSystems", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems?startingFrom={2}&maximumResults={3}", new Object[]{this.serverName, userId, Integer.toString(startingFrom), Integer.toString(maxPageSize)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getFileSystems", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getFileSystems", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getFileSystems", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public Folder getFolderByGUID(String userId, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByGUID");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFileSystemByGUID");
        FolderResponse restResult = this.restClient.callFolderGetRESTCall("getFileSystemByGUID", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}", this.serverName, userId, folderGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getFileSystemByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getFileSystemByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getFileSystemByGUID", (FFDCResponseBase)restResult);
        return restResult.getFolder();
    }

    public Folder getFolderByPathName(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByUniqueName";
        String nameParameter = "pathName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/by-path-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByUniqueName");
        this.invalidParameterHandler.validateName(pathName, "pathName", "getFileSystemByUniqueName");
        FolderResponse restResult = this.restClient.callFolderGetRESTCall("getFileSystemByUniqueName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/by-path-name/{2}", this.serverName, userId, pathName);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getFileSystemByUniqueName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getFileSystemByUniqueName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getFileSystemByUniqueName", (FFDCResponseBase)restResult);
        return restResult.getFolder();
    }

    public List<String> getNestedFolders(String userId, String anchorGUID, int startingFrom, int maxPageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedFolders";
        String anchorGUIDParameter = "anchorGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/anchor/{2}/folders?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getNestedFolders");
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", "getNestedFolders");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getNestedFolders", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/anchor/{2}/folders?startingFrom={3}&maximumResults={4}", new Object[]{this.serverName, userId, anchorGUID, Integer.toString(startingFrom), Integer.toString(maxPageSize)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getNestedFolders", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getNestedFolders", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getNestedFolders", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public List<String> getFolderFiles(String userId, String folderGUID, int startingFrom, int maxPageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderFiles";
        String anchorGUIDParameter = "folderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getFolderFiles");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFolderFiles");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getFolderFiles", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files?startingFrom={3}&maximumResults={4}", new Object[]{this.serverName, userId, folderGUID, Integer.toString(startingFrom), Integer.toString(maxPageSize)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getFolderFiles", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getFolderFiles", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getFolderFiles", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }
}

