/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingAvroFileInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileAssetRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class AvroFileAssetOwner
implements AssetOnboardingAvroFileInterface {
    private String serverName;
    private String serverPlatformRootURL;
    private AssetOwnerRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public AvroFileAssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
    }

    public AvroFileAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public List<String> addAvroFileToCatalog(String userId, String displayName, String description, String fullPath) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAvroFileToCatalog";
        String pathParameter = "fullPath";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/avro";
        this.invalidParameterHandler.validateUserId(userId, "addAvroFileToCatalog");
        this.invalidParameterHandler.validateName(fullPath, "fullPath", "addAvroFileToCatalog");
        NewFileAssetRequestBody requestBody = new NewFileAssetRequestBody();
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(fullPath);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addAvroFileToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/avro", requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUIDs();
    }
}

