/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetClassificationInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetDecommissioningInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetKnowledgeInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetReviewInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OriginRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OwnerRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;

public class AssetOwner
extends ConnectedAssetClientBase
implements AssetKnowledgeInterface,
AssetOnboardingInterface,
AssetClassificationInterface,
AssetReviewInterface,
AssetDecommissioningInterface {
    private AssetOwnerRESTClient restClient;
    private static final String serviceURLName = "asset-owner";

    public AssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
    }

    public AssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public List<String> getTypesOfAsset(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAsset";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAsset");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTypesOfAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types", new Object[]{this.serverName, userId});
        return restResult.getNames();
    }

    public Map<String, String> getTypesOfAssetWithDescriptions(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAssetWithDescriptions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types/descriptions";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAssetWithDescriptions");
        StringMapResponse restResult = this.restClient.callStringMapGetRESTCall("getTypesOfAssetWithDescriptions", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types/descriptions", new Object[]{this.serverName, userId});
        return restResult.getStringMap();
    }

    public String addAssetToCatalog(String userId, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetToCatalog";
        String typeNameParameter = "typeName";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "addAssetToCatalog");
        this.invalidParameterHandler.validateName(typeName, "typeName", "addAssetToCatalog");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "addAssetToCatalog");
        AssetRequestBody requestBody = new AssetRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAssetToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}", requestBody, new Object[]{this.serverName, userId, typeName});
        return restResult.getGUID();
    }

    public String addSchemaToAsset(String userId, String assetGUID, SchemaType schemaType, List<SchemaAttribute> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaToAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schema-type";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaToAsset");
        SchemaRequestBody requestBody = new SchemaRequestBody();
        requestBody.setSchemaType(schemaType);
        requestBody.setSchemaAttributes(schemaAttributes);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addSchemaToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schema-type", requestBody, new Object[]{this.serverName, userId, assetGUID});
        return restResult.getGUID();
    }

    public void addSchemaAttributesToSchema(String userId, String schemaTypeGUID, List<SchemaAttribute> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaAttributesToSchema";
        String schemaTypeGUIDParameter = "schemaTypeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schemas/{2}/schema-attributes";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaAttributesToSchema");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "addSchemaAttributesToSchema");
        this.restClient.callVoidPostRESTCall("addSchemaAttributesToSchema", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schemas/{2}/schema-attributes", schemaAttributes, new Object[]{this.serverName, userId, schemaTypeGUID});
    }

    public void addConnectionToAsset(String userId, String assetGUID, String assetSummary, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addConnectionToAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connection";
        this.invalidParameterHandler.validateUserId(userId, "addConnectionToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addConnectionToAsset");
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setShortDescription(assetSummary);
        requestBody.setConnection(connection);
        this.restClient.callVoidPostRESTCall("addConnectionToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connection", requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void addSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSemanticAssignment";
        String assetGUIDParameter = "assetGUID";
        String glossaryTermParameter = "glossaryTermGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings{4}";
        this.invalidParameterHandler.validateUserId(userId, "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "addSemanticAssignment");
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, glossaryTermGUID});
        } else {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings{4}", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID, glossaryTermGUID});
        }
    }

    public void removeSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSemanticAssignment";
        String assetGUIDParameter = "assetGUID";
        String glossaryTermParameter = "glossaryTermGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/delete";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "addSemanticAssignment");
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, glossaryTermGUID});
        } else {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings{4}/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID, glossaryTermGUID});
        }
    }

    public void addAssetOrigin(String userId, String assetGUID, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetOrigin";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin";
        this.invalidParameterHandler.validateUserId(userId, "addAssetOrigin");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addAssetOrigin");
        OriginRequestBody requestBody = new OriginRequestBody();
        requestBody.setBusinessCapabilityGUID(businessCapabilityGUID);
        requestBody.setOrganizationGUID(organizationGUID);
        this.restClient.callVoidPostRESTCall("addAssetOrigin", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin", requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void removeAssetOrigin(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAssetOrigin";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeAssetOrigin");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeAssetOrigin");
        this.restClient.callVoidPostRESTCall("removeAssetOrigin", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void addSecurityTags(String userId, String assetGUID, String assetElementGUID, List<String> securityLabels, Map<String, Object> securityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSecurityTags";
        String assetGUIDParameter = "assetGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags";
        this.invalidParameterHandler.validateUserId(userId, "addSecurityTags");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSecurityTags");
        SecurityTagsRequestBody requestBody = new SecurityTagsRequestBody();
        requestBody.setSecurityLabels(securityLabels);
        requestBody.setSecurityProperties(securityProperties);
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags", requestBody, new Object[]{this.serverName, userId, assetGUID});
        } else {
            this.restClient.callVoidPostRESTCall("addSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags", requestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID});
        }
    }

    public void removeSecurityTags(String userId, String assetGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSecurityTags";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "addSecurityTags");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSecurityTags");
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags/delete";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags/delete";
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
        } else {
            this.restClient.callVoidPostRESTCall("addSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID});
        }
    }

    public void updateAssetZones(String userId, String assetGUID, List<String> assetZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetZones";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/governance-zones";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetZones");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetZones");
        this.restClient.callVoidPostRESTCall("updateAssetZones", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/governance-zones", assetZones, new Object[]{this.serverName, userId, assetGUID});
    }

    public void updateAssetOwner(String userId, String assetGUID, String ownerId, OwnerType ownerType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetOwner";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetOwner");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetOwner");
        OwnerRequestBody requestBody = new OwnerRequestBody();
        requestBody.setOwnerId(ownerId);
        requestBody.setOwnerType(ownerType);
        this.restClient.callVoidPostRESTCall("updateAssetOwner", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner", requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public List<Asset> getAssetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-name?startFrom={2}&pageSize={3}";
        String methodName = "getAssetsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAssetsByName");
        AssetsResponse restResult = this.restClient.callAssetsPostRESTCall("getAssetsByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-name?startFrom={2}&pageSize={3}", name, new Object[]{this.serverName, userId, startFrom, pageSize});
        return restResult.getAssets();
    }

    public List<Asset> findAssets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}";
        String methodName = "findAssets";
        String searchParameter = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAssets");
        AssetsResponse restResult = this.restClient.callAssetsPostRESTCall("findAssets", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}", searchString, new Object[]{this.serverName, userId, startFrom, pageSize});
        return restResult.getAssets();
    }

    public Asset getAssetSummary(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetSummary";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetSummary");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAssetSummary");
        return super.getAssetSummary((OCFRESTClient)this.restClient, serviceURLName, userId, assetGUID, "getAssetSummary");
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    public Connector getConnectorToAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorToAsset";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectorToAsset");
        try {
            return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, this.getConnectionForAsset((OCFRESTClient)this.restClient, serviceURLName, userId, assetGUID), "getConnectorToAsset");
        }
        catch (ConnectionCheckedException error) {
            throw new InvalidParameterException(error.getErrorMessage(), (OCFCheckedExceptionBase)error, "connection to asset " + assetGUID);
        }
        catch (ConnectorCheckedException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
    }

    public List<DiscoveryAnalysisReport> getDiscoveryAnalysisReports(String userId, String assetGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryAnalysisReports";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/discovery-analysis-reports?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryAnalysisReports");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getDiscoveryAnalysisReports");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryAnalysisReports");
        DiscoveryAnalysisReportListResponse restResult = this.restClient.callDiscoveryAnalysisReportListGetRESTCall("getDiscoveryAnalysisReports", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/discovery-analysis-reports?startingFrom={4}&maximumResults={5}", new Object[]{this.serverName, userId, assetGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        return restResult.getDiscoveryAnalysisReports();
    }

    public List<String> getTypesOfAnnotation(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotation";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotation");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTypesOfAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types", new Object[]{this.serverName, userId});
        return restResult.getNames();
    }

    public Map<String, String> getTypesOfAnnotationWithDescriptions(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotationWithDescriptions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types/descriptions";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotationWithDescriptions");
        StringMapResponse restResult = this.restClient.callStringMapGetRESTCall("getTypesOfAnnotationWithDescriptions", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types/descriptions", new Object[]{this.serverName, userId});
        return restResult.getStringMap();
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryReportAnnotations";
        String discoveryReportGUIDParameter = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/discovery-analysis-reports/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryReportAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getDiscoveryReportAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/discovery-analysis-reports/{2}?startingFrom={3}&maxPageSize={4}", requestBody, new Object[]{this.serverName, userId, discoveryReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        return restResult.getAnnotations();
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameter = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getExtendedAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/{2}?startingFrom={3}&maxPageSize={4}", requestBody, new Object[]{this.serverName, userId, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        return restResult.getAnnotations();
    }

    public void deleteAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "deleteAsset");
        this.restClient.callVoidPostRESTCall("deleteAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }
}

