/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingValidValues;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValuesRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.properties.ValidValueConsumer;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValueConsumersResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValuesResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValue;

public class ValidValuesAssetOwner
extends AssetOwner
implements AssetOnboardingValidValues {
    public ValidValuesAssetOwner(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
    }

    public ValidValuesAssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
    }

    public ValidValuesAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public ValidValuesAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
    }

    public String createValidValueSet(String userId, String qualifiedName, String displayName, String description, String usage, String scope, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueSet";
        String nameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}//valid-values/new-set";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueSet");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createValidValueSet");
        ValidValuesRequestBody requestBody = new ValidValuesRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createValidValueSet", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}//valid-values/new-set", requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createValidValueDefinition(String userId, String setGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueDefinition";
        String nameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/new-definition";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueDefinition");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createValidValueDefinition");
        ValidValuesRequestBody requestBody = new ValidValuesRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setPreferredValue(preferredValue);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createValidValueDefinition", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/new-definition", requestBody, new Object[]{this.serverName, userId, setGUID});
        return restResult.getGUID();
    }

    public void updateValidValue(String userId, String validValueGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateValidValue";
        String nameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateValidValue");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateValidValue");
        ValidValuesRequestBody requestBody = new ValidValuesRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setPreferredValue(preferredValue);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateValidValue", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/update", requestBody, new Object[]{this.serverName, userId, validValueGUID});
    }

    public void deleteValidValue(String userId, String validValueGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteValidValue";
        String nameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteValidValue");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteValidValue");
        this.restClient.callVoidPostRESTCall("deleteValidValue", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/delete", qualifiedName, new Object[]{this.serverName, userId, validValueGUID});
    }

    public void attachValidValueToSet(String userId, String setGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachValidValueToSet";
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members/{3}";
        this.invalidParameterHandler.validateUserId(userId, "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "attachValidValueToSet");
        this.restClient.callVoidPostRESTCall("attachValidValueToSet", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members/{3}", nullRequestBody, new Object[]{this.serverName, userId, setGUID, validValueGUID});
    }

    public void detachValidValueFromSet(String userId, String setGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachValidValueFromSet";
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "detachValidValueFromSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "detachValidValueFromSet");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "detachValidValueFromSet");
        this.restClient.callVoidPostRESTCall("detachValidValueFromSet", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, setGUID, validValueGUID});
    }

    public void linkValidValueToImplementation(String userId, String validValueGUID, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkValidValueToImplementation";
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/implementations/{3}";
        this.invalidParameterHandler.validateUserId(userId, "linkValidValueToImplementation");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "linkValidValueToImplementation");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "linkValidValueToImplementation");
        this.restClient.callVoidPostRESTCall("linkValidValueToImplementation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/implementations/{3}", nullRequestBody, new Object[]{this.serverName, userId, validValueGUID, assetGUID});
    }

    public void classifyAssetAsReferenceData(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyAssetAsReferenceData";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/classify-as-reference-data";
        this.invalidParameterHandler.validateUserId(userId, "classifyAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "classifyAssetAsReferenceData");
        this.restClient.callVoidPostRESTCall("classifyAssetAsReferenceData", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/classify-as-reference-data", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void unlinkValidValueFromImplementation(String userId, String validValueGUID, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkValidValueFromImplementation";
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/implementations/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkValidValueFromImplementation");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "unlinkValidValueFromImplementation");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "unlinkValidValueFromImplementation");
        this.restClient.callVoidPostRESTCall("unlinkValidValueFromImplementation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/implementations/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, validValueGUID, assetGUID});
    }

    public void declassifyAssetAsReferenceData(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "declassifyAssetAsReferenceData";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/declassify-as-reference-data";
        this.invalidParameterHandler.validateUserId(userId, "declassifyAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "declassifyAssetAsReferenceData");
        this.restClient.callVoidPostRESTCall("declassifyAssetAsReferenceData", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/declassify-as-reference-data", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void assignValidValueToConsumer(String userId, String validValueGUID, String consumerGUID, boolean strictRequirement) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "assignValidValueToConsumer";
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/consumers/{3}";
        this.invalidParameterHandler.validateUserId(userId, "assignValidValueToConsumer");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "assignValidValueToConsumer");
        this.invalidParameterHandler.validateGUID(consumerGUID, "consumerGUID", "assignValidValueToConsumer");
        BooleanRequestBody requestBody = new BooleanRequestBody();
        requestBody.setFlag(strictRequirement);
        this.restClient.callVoidPostRESTCall("assignValidValueToConsumer", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/consumers/{3}", requestBody, new Object[]{this.serverName, userId, validValueGUID, consumerGUID});
    }

    public void unassignValidValueFromConsumer(String userId, String validValueGUID, String consumerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unassignValidValueFromConsumer";
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/consumers/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unassignValidValueFromConsumer");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "unassignValidValueFromConsumer");
        this.invalidParameterHandler.validateGUID(consumerGUID, "consumerGUID", "unassignValidValueFromConsumer");
        this.restClient.callVoidPostRESTCall("unassignValidValueFromConsumer", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/consumers/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, validValueGUID, consumerGUID});
    }

    public ValidValue getValidValueByGUID(String userId, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByGUID";
        String validValueGUIDParameter = "validValueGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByGUID");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValueByGUID");
        ValidValueResponse restResult = this.restClient.callValidValueGetRESTCall("getValidValueByGUID", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}", this.serverName, userId, validValueGUID);
        return restResult.getValidValue();
    }

    public List<ValidValue> getValidValueByName(String userId, String validValueName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByName";
        String validValueNameParameter = "validValueName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/by-name";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByName");
        this.invalidParameterHandler.validateName(validValueName, "validValueName", "getValidValueByName");
        ValidValuesResponse restResult = this.restClient.callValidValuesPostRESTCall("getValidValueByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/by-name", validValueName, this.serverName, userId);
        return restResult.getValidValues();
    }

    public List<ValidValue> findValidValues(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByName";
        String parameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/by-search-string";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByName");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "getValidValueByName");
        ValidValuesResponse restResult = this.restClient.callValidValuesPostRESTCall("getValidValueByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/by-search-string", searchString, this.serverName, userId);
        return restResult.getValidValues();
    }

    public List<ValidValue> getValidValueSetMembers(String userId, String validValueSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueSetMembers";
        String validValueGUIDParameter = "validValueSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueSetMembers");
        this.invalidParameterHandler.validateGUID(validValueSetGUID, "validValueSetGUID", "getValidValueSetMembers");
        ValidValuesResponse restResult = this.restClient.callValidValuesGetRESTCall("getValidValueSetMembers", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members?startFrom={3}&pageSize={4}", this.serverName, userId, validValueSetGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getValidValues();
    }

    public List<ValidValue> getSetsForValidValue(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForValidValue";
        String validValueGUIDParameter = "validValueSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/set-membership?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueSetGUID", "getSetsForValidValue");
        ValidValuesResponse restResult = this.restClient.callValidValuesGetRESTCall("getSetsForValidValue", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/set-membership?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getValidValues();
    }

    public List<ValidValueConsumer> getValidValuesConsumers(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForValidValue";
        String validValueGUIDParameter = "validValueSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/consumers?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueSetGUID", "getSetsForValidValue");
        ValidValueConsumersResponse restResult = this.restClient.callValidValueConsumersGetRESTCall("getSetsForValidValue", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/consumers?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getValidValueConsumers();
    }

    public List<Asset> getValidValuesImplementations(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForValidValue";
        String validValueGUIDParameter = "validValueSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/implementations?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueSetGUID", "getSetsForValidValue");
        AssetsResponse restResult = this.restClient.callAssetsGetRESTCall("getSetsForValidValue", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/implementations?startFrom={3}&pageSize={4}", new Object[]{this.serverName, userId, validValueGUID, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getAssets();
    }
}

