/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingCSVFileInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewCSVFileAssetRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CSVFileAssetOwner
extends AssetOwner
implements AssetOnboardingCSVFileInterface {
    public CSVFileAssetOwner(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformRootURL, AssetOwnerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.addCSVFileToCatalog(userId, displayName, description, fullPath, null, null, null);
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCSVFileToCatalog";
        String pathParameter = "fullPath";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/csv";
        this.invalidParameterHandler.validateUserId(userId, "addCSVFileToCatalog");
        this.invalidParameterHandler.validateName(fullPath, "fullPath", "addCSVFileToCatalog");
        NewCSVFileAssetRequestBody requestBody = new NewCSVFileAssetRequestBody();
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(fullPath);
        requestBody.setColumnHeaders(columnHeaders);
        requestBody.setDelimiterCharacter(delimiterCharacter);
        requestBody.setQuoteCharacter(quoteCharacter);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addCSVFileToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/csv", requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUIDs();
    }
}

