/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingAvroFileInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileAssetRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class AvroFileAssetOwner
extends AssetOwner
implements AssetOnboardingAvroFileInterface {
    public AvroFileAssetOwner(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
    }

    public AvroFileAssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
    }

    public AvroFileAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public AvroFileAssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
    }

    public AvroFileAssetOwner(String serverName, String serverPlatformRootURL, AssetOwnerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public List<String> addAvroFileToCatalog(String userId, String displayName, String description, String fullPath) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAvroFileToCatalog";
        String pathParameter = "fullPath";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/avro";
        this.invalidParameterHandler.validateUserId(userId, "addAvroFileToCatalog");
        this.invalidParameterHandler.validateName(fullPath, "fullPath", "addAvroFileToCatalog");
        NewFileAssetRequestBody requestBody = new NewFileAssetRequestBody();
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(fullPath);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addAvroFileToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/avro", requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUIDs();
    }
}

