/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetClassificationInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetDecommissioningInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetDuplicateManagementInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetKnowledgeInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetReviewInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.CombinedSchemaRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.OriginRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.OwnerRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.TemplateClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;

public class AssetOwner
extends ConnectedAssetClientBase
implements AssetKnowledgeInterface,
AssetOnboardingInterface,
AssetClassificationInterface,
AssetReviewInterface,
AssetDecommissioningInterface,
AssetDuplicateManagementInterface {
    protected AssetOwnerRESTClient restClient;
    private static final String serviceURLName = "asset-owner";
    private static final String defaultAssetType = "Asset";

    public AssetOwner(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, auditLog);
    }

    public AssetOwner(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
    }

    public AssetOwner(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public AssetOwner(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public AssetOwner(String serverName, String serverPlatformRootURL, AssetOwnerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, auditLog);
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public List<String> getTypesOfAsset(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAsset";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAsset");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTypesOfAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types", new Object[]{this.serverName, userId});
        return restResult.getNames();
    }

    public Map<String, String> getTypesOfAssetWithDescriptions(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAssetWithDescriptions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types/descriptions";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAssetWithDescriptions");
        StringMapResponse restResult = this.restClient.callStringMapGetRESTCall("getTypesOfAssetWithDescriptions", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types/descriptions", new Object[]{this.serverName, userId});
        return restResult.getStringMap();
    }

    public String addAssetToCatalog(String userId, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetToCatalog";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addAssetToCatalog");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "addAssetToCatalog");
        AssetProperties assetProperties = new AssetProperties();
        assetProperties.setTypeName(typeName);
        assetProperties.setQualifiedName(qualifiedName);
        assetProperties.setDisplayName(displayName);
        assetProperties.setDescription(description);
        assetProperties.setAdditionalProperties(additionalProperties);
        assetProperties.setExtendedProperties(extendedProperties);
        return this.addAssetToCatalog(userId, assetProperties);
    }

    public String addAssetToCatalog(String userId, AssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetToCatalog";
        String assetPropertiesParameterName = "assetProperties";
        String qualifiedNameParameter = "assetProperties.getQualifiedName()";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "addAssetToCatalog");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "addAssetToCatalog");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.getQualifiedName()", "addAssetToCatalog");
        if (assetProperties.getTypeName() == null) {
            assetProperties.setTypeName(defaultAssetType);
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAssetToCatalog", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}", assetProperties, new Object[]{this.serverName, userId, assetProperties.getTypeName()});
        return restResult.getGUID();
    }

    public String addAssetToCatalogUsingTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/from-template/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createDatabaseFromTemplate");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseFromTemplate", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/from-template/{2}", templateProperties, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public String addCombinedSchemaToAsset(String userId, String assetGUID, SchemaTypeProperties schemaType, List<SchemaAttributeProperties> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCombinedSchemaToAsset";
        String assetGUIDParameter = "assetGUID";
        String schemaTypeParameter = "schemaType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/with-attributes";
        this.invalidParameterHandler.validateUserId(userId, "addCombinedSchemaToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addCombinedSchemaToAsset");
        this.invalidParameterHandler.validateObject((Object)schemaType, "schemaType", "addCombinedSchemaToAsset");
        CombinedSchemaRequestBody requestBody = new CombinedSchemaRequestBody();
        requestBody.setSchemaType(schemaType);
        requestBody.setSchemaAttributes(schemaAttributes);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCombinedSchemaToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/with-attributes", requestBody, new Object[]{this.serverName, userId, assetGUID});
        return restResult.getGUID();
    }

    public String addSchemaTypeToAsset(String userId, String assetGUID, SchemaTypeProperties schemaType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaTypeToAsset";
        String assetGUIDParameter = "assetGUID";
        String schemaTypeParameter = "schemaType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaTypeToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaTypeToAsset");
        this.invalidParameterHandler.validateObject((Object)schemaType, "schemaType", "addSchemaTypeToAsset");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addSchemaTypeToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas", schemaType, new Object[]{this.serverName, userId, assetGUID});
        return restResult.getGUID();
    }

    public void attachSchemaTypeToAsset(String userId, String assetGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachSchemaTypeToAsset";
        String assetGUIDParameter = "assetGUID";
        String schemaTypeParameter = "schemaTypeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/attach";
        this.invalidParameterHandler.validateUserId(userId, "attachSchemaTypeToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "attachSchemaTypeToAsset");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "attachSchemaTypeToAsset");
        this.restClient.callVoidPostRESTCall("attachSchemaTypeToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/attach", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, schemaTypeGUID});
    }

    public String detachSchemaTypeFromAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachSchemaTypeFromAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/detach";
        this.invalidParameterHandler.validateUserId(userId, "detachSchemaTypeFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "detachSchemaTypeFromAsset");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("detachSchemaTypeFromAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/detach", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
        return restResult.getGUID();
    }

    public void deleteAssetSchemaType(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAssetSchemaType";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAssetSchemaType");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "deleteAssetSchemaType");
        this.restClient.callGUIDPostRESTCall("deleteAssetSchemaType", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void addSchemaAttributes(String serverName, String userId, String assetGUID, String parentGUID, List<SchemaAttributeProperties> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaAttributesToSchemaType";
        String assetGUIDParameter = "assetGUID";
        String parentGUIDParameter = "parentGUID";
        String schemaAttributesParameter = "schemaAttributes";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/schema-attributes/list";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaAttributesToSchemaType");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaAttributesToSchemaType");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "addSchemaAttributesToSchemaType");
        this.invalidParameterHandler.validateObject(schemaAttributes, "schemaAttributes", "addSchemaAttributesToSchemaType");
        this.restClient.callVoidPostRESTCall("addSchemaAttributesToSchemaType", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/schema-attributes/list", schemaAttributes, new Object[]{serverName, userId, assetGUID, parentGUID});
    }

    public String addSchemaAttribute(String serverName, String userId, String assetGUID, String parentGUID, SchemaAttributeProperties schemaAttribute) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaAttributes";
        String assetGUIDParameter = "assetGUID";
        String parentGUIDParameter = "parentGUID";
        String schemaAttributeParameter = "schemaAttribute";
        String qualifiedNameParameter = "schemaAttribute.getQualifiedName()";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/schema-attributes";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaAttributes");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaAttributes");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "addSchemaAttributes");
        this.invalidParameterHandler.validateObject((Object)schemaAttribute, "schemaAttribute", "addSchemaAttributes");
        this.invalidParameterHandler.validateName(schemaAttribute.getQualifiedName(), "schemaAttribute.getQualifiedName()", "addSchemaAttributes");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addSchemaAttributes", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/schema-attributes", schemaAttribute, new Object[]{serverName, userId, assetGUID, parentGUID});
        return restResult.getGUID();
    }

    public void addConnectionToAsset(String userId, String assetGUID, String assetSummary, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addConnectionToAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connection";
        this.invalidParameterHandler.validateUserId(userId, "addConnectionToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addConnectionToAsset");
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setShortDescription(assetSummary);
        requestBody.setConnection(connection);
        this.restClient.callVoidPostRESTCall("addConnectionToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connection", requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void addSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSemanticAssignment";
        String assetGUIDParameter = "assetGUID";
        String glossaryTermParameter = "glossaryTermGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/{3}";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}";
        this.invalidParameterHandler.validateUserId(userId, "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "addSemanticAssignment");
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/{3}", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, glossaryTermGUID});
        } else {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID, glossaryTermGUID});
        }
    }

    public void removeSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSemanticAssignment";
        String assetGUIDParameter = "assetGUID";
        String glossaryTermParameter = "glossaryTermGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/delete";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "addSemanticAssignment");
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, glossaryTermGUID});
        } else {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID, glossaryTermGUID});
        }
    }

    public void addAssetOrigin(String userId, String assetGUID, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetOrigin";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin";
        this.invalidParameterHandler.validateUserId(userId, "addAssetOrigin");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addAssetOrigin");
        OriginRequestBody requestBody = new OriginRequestBody();
        requestBody.setBusinessCapabilityGUID(businessCapabilityGUID);
        requestBody.setOrganizationGUID(organizationGUID);
        this.restClient.callVoidPostRESTCall("addAssetOrigin", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin", requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void removeAssetOrigin(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAssetOrigin";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeAssetOrigin");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeAssetOrigin");
        this.restClient.callVoidPostRESTCall("removeAssetOrigin", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void publishAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/publish";
        this.invalidParameterHandler.validateUserId(userId, "publishAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "publishAsset");
        this.restClient.callVoidPostRESTCall("publishAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/publish", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void withdrawAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/withdraw";
        this.invalidParameterHandler.validateUserId(userId, "withdrawAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "withdrawAsset");
        this.restClient.callVoidPostRESTCall("withdrawAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/withdraw", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void updateAssetZones(String userId, String assetGUID, List<String> assetZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetZones";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/governance-zones";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetZones");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetZones");
        this.restClient.callVoidPostRESTCall("updateAssetZones", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/governance-zones", assetZones, new Object[]{this.serverName, userId, assetGUID});
    }

    public void updateAssetOwner(String userId, String assetGUID, String ownerId, OwnerType ownerType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetOwner";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetOwner");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetOwner");
        OwnerRequestBody requestBody = new OwnerRequestBody();
        requestBody.setOwnerId(ownerId);
        requestBody.setOwnerType(ownerType);
        this.restClient.callVoidPostRESTCall("updateAssetOwner", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner", requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void addSecurityTags(String userId, String assetGUID, String assetElementGUID, List<String> securityLabels, Map<String, Object> securityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSecurityTags";
        String assetGUIDParameter = "assetGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags";
        this.invalidParameterHandler.validateUserId(userId, "addSecurityTags");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSecurityTags");
        SecurityTagsRequestBody requestBody = new SecurityTagsRequestBody();
        requestBody.setSecurityLabels(securityLabels);
        requestBody.setSecurityProperties(securityProperties);
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags", requestBody, new Object[]{this.serverName, userId, assetGUID});
        } else {
            this.restClient.callVoidPostRESTCall("addSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags", requestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID});
        }
    }

    public void removeSecurityTags(String userId, String assetGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSecurityTags";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSecurityTags");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeSecurityTags");
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags/delete";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags/delete";
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("removeSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
        } else {
            this.restClient.callVoidPostRESTCall("removeSecurityTags", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID, assetElementGUID});
        }
    }

    public void addTemplateClassification(String userId, String assetGUID, String name, String description, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addTemplateClassification";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "addTemplateClassification");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addTemplateClassification");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/template-classification";
        TemplateClassificationRequestBody requestBody = new TemplateClassificationRequestBody();
        requestBody.setName(name);
        requestBody.setDescription(description);
        requestBody.setAdditionalProperties(additionalProperties);
        this.restClient.callVoidPostRESTCall("addTemplateClassification", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/template-classification", requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void removeTemplateClassification(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeTemplateClassification";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeTemplateClassification");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeTemplateClassification");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/template-classification/delete";
        this.restClient.callVoidPostRESTCall("removeTemplateClassification", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/template-classification/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public List<AssetElement> getAssetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-name?startFrom={2}&pageSize={3}";
        String methodName = "getAssetsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAssetsByName");
        AssetElementsResponse restResult = this.restClient.callAssetElementsPostRESTCall("getAssetsByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-name?startFrom={2}&pageSize={3}", name, this.serverName, userId, startFrom, pageSize);
        return restResult.getAssets();
    }

    public List<AssetElement> findAssets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}";
        String methodName = "findAssets";
        String searchParameter = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAssets");
        AssetElementsResponse restResult = this.restClient.callAssetElementsPostRESTCall("findAssets", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}", searchString, this.serverName, userId, startFrom, pageSize);
        return restResult.getAssets();
    }

    public AssetElement getAssetSummary(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetSummary";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetSummary");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAssetSummary");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}";
        AssetElementResponse restResult = this.restClient.callAssetElementGetRESTCall("getAssetSummary", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}", this.serverName, userId, assetGUID);
        return restResult.getAsset();
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    public Connector getConnectorToAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorToAsset";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectorToAsset");
        try {
            return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, this.getConnectionForAsset(this.restClient, serviceURLName, userId, assetGUID), "getConnectorToAsset");
        }
        catch (ConnectionCheckedException error) {
            throw new InvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error, "connection to asset " + assetGUID);
        }
        catch (ConnectorCheckedException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
    }

    public List<DiscoveryAnalysisReport> getDiscoveryAnalysisReports(String userId, String assetGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryAnalysisReports";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/discovery-analysis-reports?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryAnalysisReports");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getDiscoveryAnalysisReports");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryAnalysisReports");
        DiscoveryAnalysisReportListResponse restResult = this.restClient.callDiscoveryAnalysisReportListGetRESTCall("getDiscoveryAnalysisReports", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/discovery-analysis-reports?startingFrom={4}&maximumResults={5}", this.serverName, userId, assetGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getDiscoveryAnalysisReports();
    }

    public List<String> getTypesOfAnnotation(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotation";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotation");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTypesOfAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types", new Object[]{this.serverName, userId});
        return restResult.getNames();
    }

    public Map<String, String> getTypesOfAnnotationWithDescriptions(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotationWithDescriptions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types/descriptions";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotationWithDescriptions");
        StringMapResponse restResult = this.restClient.callStringMapGetRESTCall("getTypesOfAnnotationWithDescriptions", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types/descriptions", new Object[]{this.serverName, userId});
        return restResult.getStringMap();
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryReportAnnotations";
        String discoveryReportGUIDParameter = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/discovery-analysis-reports/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryReportAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getDiscoveryReportAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/discovery-analysis-reports/{2}?startingFrom={3}&maxPageSize={4}", requestBody, this.serverName, userId, discoveryReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getAnnotations();
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameter = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getExtendedAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/{2}?startingFrom={3}&maxPageSize={4}", requestBody, this.serverName, userId, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getAnnotations();
    }

    public void deleteAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "deleteAsset");
        this.restClient.callVoidPostRESTCall("deleteAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/delete", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void linkElementsAsDuplicates(String userId, String element1GUID, String element2GUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "linkElementsAsDuplicates");
        this.restClient.callVoidPostRESTCall("linkElementsAsDuplicates", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}", nullRequestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }

    public void unlinkElementsAsDuplicates(String userId, String element1GUID, String element2GUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "unlinkElementsAsDuplicates");
        this.restClient.callVoidPostRESTCall("unlinkElementsAsDuplicates", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }
}

