/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import org.odpi.openmetadata.accessservices.assetowner.api.AssetOwnerEventInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOwnerEventListener;
import org.odpi.openmetadata.accessservices.assetowner.connectors.outtopic.AssetOwnerOutTopicClientConnector;
import org.odpi.openmetadata.accessservices.assetowner.ffdc.AssetOwnerErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class AssetOwnerEventClient
implements AssetOwnerEventInterface {
    private static final String serviceName = "Asset Owner OMAS";
    private String serverName;
    private String serverPlatformURLRoot;
    private OCFRESTClient restClient;
    private AuditLog auditLog;
    private String callerId;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private AssetOwnerOutTopicClientConnector configurationEventTopicConnector = null;

    public AssetOwnerEventClient(String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword, int maxPageSize, AuditLog auditLog, String callerId) throws InvalidParameterException {
        String methodName = "Constructor (with REST Client)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with REST Client)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = serverPassword == null ? new OCFRESTClient(serverName, serverPlatformURLRoot) : new OCFRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword, auditLog);
        this.auditLog = auditLog;
        this.callerId = callerId;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    public void registerListener(String userId, AssetOwnerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "registerListener";
        String nameParameter = "listener";
        String callerIdParameter = "callerId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/topics/out-topic-connection/{2}";
        this.invalidParameterHandler.validateUserId(userId, "registerListener");
        this.invalidParameterHandler.validateObject((Object)listener, "listener", "registerListener");
        this.invalidParameterHandler.validateName(this.callerId, "callerId", "registerListener");
        if (this.configurationEventTopicConnector == null) {
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            ConnectionResponse restResult = this.restClient.callOCFConnectionGetRESTCall("registerListener", urlTemplate, new Object[]{this.serverName, userId, this.callerId});
            Connection topicConnection = restResult.getConnection();
            Connector connector = connectorBroker.getConnector(topicConnection);
            if (connector == null) {
                throw new ConnectorCheckedException(AssetOwnerErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot}), this.getClass().getName(), "registerListener");
            }
            if (connector instanceof AssetOwnerOutTopicClientConnector) {
                this.configurationEventTopicConnector = (AssetOwnerOutTopicClientConnector)connector;
                this.configurationEventTopicConnector.start();
            } else {
                throw new ConnectorCheckedException(AssetOwnerErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot, AssetOwnerOutTopicClientConnector.class.getName()}), this.getClass().getName(), "registerListener");
            }
        }
        this.configurationEventTopicConnector.registerListener(userId, listener);
    }
}

