/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.RelatedElementsManagementInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.ResourceListProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.StakeholderProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ElementStubListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class AssetOwnerBaseClient
implements RelatedElementsManagementInterface {
    final String serverName;
    final String serverPlatformURLRoot;
    final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    final AssetOwnerRESTClient restClient;
    private static final String elementsURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements";
    protected NullRequestBody nullRequestBody = new NullRequestBody();

    public AssetOwnerBaseClient(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public AssetOwnerBaseClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformURLRoot);
    }

    public AssetOwnerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public AssetOwnerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new AssetOwnerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public AssetOwnerBaseClient(String serverName, String serverPlatformURLRoot, AssetOwnerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    String createReferenceable(String userId, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    String createReferenceableWithAnchor(String userId, String anchorGUID, String anchorGUIDParameterName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, anchorGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    void updateReferenceable(String userId, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate});
    }

    void setReferenceableClassification(String userId, String elementGUID, String elementGUIDParameter, ClassificationProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void removeReferenceableClassification(String userId, String elementGUID, String elementGUIDParameter, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void setupRelationship(String userId, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    String setupMultiLinkRelationship(String userId, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        requestBody.setProperties(properties);
        GUIDResponse response = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
        return response.getGUID();
    }

    public void updateRelationship(String userId, String relationshipGUID, String relationshipGUIDParameterName, boolean isMergeUpdate, String relationshipName, RelationshipProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID, isMergeUpdate});
    }

    void clearRelationship(String userId, String relationshipGUID, String relationshipGUIDParameterName, String relationshipName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID});
    }

    void clearRelationship(String userId, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    List<RelatedElement> getRelatedElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        RelatedElementListResponse restResult = this.restClient.callRelatedElementListGetRESTCall(methodName, urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    List<ElementStub> getElementStubsByName(String userId, String name, String nameParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ElementStubListResponse restResult = this.restClient.callElementStubListGetRESTCall(methodName, urlTemplate, this.serverName, userId, name, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public void removeReferenceable(String userId, String elementGUID, String elementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public void setupMoreInformation(String userId, String elementGUID, RelationshipProperties properties, String detailGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/{2}/more-information/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, properties, detailGUID, "detailGUID", urlTemplate, "setupMoreInformation");
    }

    public void clearMoreInformation(String userId, String elementGUID, String detailGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/{2}/more-information/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, detailGUID, "detailGUID", urlTemplate, "clearMoreInformation");
    }

    public List<RelatedElement> getMoreInformation(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/more-information/by-descriptive-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, "getMoreInformation");
    }

    public List<RelatedElement> getDescriptiveElements(String userId, String detailGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/more-information/by-detail-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, detailGUID, "detailGUID", urlTemplate, startFrom, pageSize, "getDescriptiveElements");
    }

    public void setupStakeholder(String userId, String elementGUID, StakeholderProperties properties, String stakeholderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/{2}/stakeholders/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, (RelationshipProperties)properties, stakeholderGUID, "stakeholderGUID", urlTemplate, "setupStakeholder");
    }

    public void clearStakeholder(String userId, String elementGUID, String stakeholderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/{2}/stakeholders/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, stakeholderGUID, "stakeholderGUID", urlTemplate, "clearStakeholder");
    }

    public List<RelatedElement> getStakeholders(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/stakeholders/by-commissioned-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, "getStakeholders");
    }

    public List<RelatedElement> getStakeholderCommissionedElements(String userId, String stakeholderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/stakeholders/by-stakeholder/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, stakeholderGUID, "stakeholderGUID", urlTemplate, startFrom, pageSize, "getStakeholderCommissionedElements");
    }

    public void setupResource(String userId, String elementGUID, ResourceListProperties properties, String resourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/{2}/resource-list/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, (RelationshipProperties)properties, resourceGUID, "resourceGUID", urlTemplate, "setupResource");
    }

    public void clearResource(String userId, String elementGUID, String resourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/{2}/resource-list/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, resourceGUID, "resourceGUID", urlTemplate, "clearResource");
    }

    public List<RelatedElement> getResourceList(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/resource-list/by-assignee/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, "getResourceList");
    }

    public List<RelatedElement> getSupportedByResource(String userId, String resourceGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/related-elements/resource-list/by-resource/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, resourceGUID, "resourceGUID", urlTemplate, startFrom, pageSize, "getSupportedByResource");
    }
}

