/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingValidValues;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValueResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValuesRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValuesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ValidValuesAssetOwner
extends AssetOwner
implements AssetOnboardingValidValues {
    public ValidValuesAssetOwner(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public ValidValuesAssetOwner(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ValidValuesAssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ValidValuesAssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public ValidValuesAssetOwner(String serverName, String serverPlatformURLRoot, AssetOwnerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public String createValidValueSet(String userId, String qualifiedName, String displayName, String description, String usage, String scope, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueSet";
        String nameParameter = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}//valid-values/new-set";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueSet");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createValidValueSet");
        ValidValuesRequestBody requestBody = new ValidValuesRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createValidValueSet", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createValidValueDefinition(String userId, String setGUID, boolean isDefaultValue, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueDefinition";
        String nameParameter = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/new-definition?isDefaultValue={2}";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueDefinition");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createValidValueDefinition");
        ValidValuesRequestBody requestBody = new ValidValuesRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setPreferredValue(preferredValue);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createValidValueDefinition", urlTemplate, requestBody, new Object[]{this.serverName, userId, setGUID, isDefaultValue});
        return restResult.getGUID();
    }

    public void updateValidValue(String userId, String validValueGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateValidValue";
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "updateValidValue");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateValidValue");
        ValidValuesRequestBody requestBody = new ValidValuesRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setPreferredValue(preferredValue);
        requestBody.setIsDeprecated(isDeprecated);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateValidValue", urlTemplate, requestBody, new Object[]{this.serverName, userId, validValueGUID});
    }

    public void deleteValidValue(String userId, String validValueGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteValidValue";
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "deleteValidValue");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteValidValue");
        this.restClient.callVoidPostRESTCall("deleteValidValue", urlTemplate, qualifiedName, new Object[]{this.serverName, userId, validValueGUID});
    }

    public void attachValidValueToSet(String userId, String setGUID, String validValueGUID, boolean isDefaultValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachValidValueToSet";
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members/{3}?isDefaultValue={4}";
        this.invalidParameterHandler.validateUserId(userId, "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "attachValidValueToSet");
        this.restClient.callVoidPostRESTCall("attachValidValueToSet", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, setGUID, validValueGUID, isDefaultValue});
    }

    public void detachValidValueFromSet(String userId, String setGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachValidValueFromSet";
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "detachValidValueFromSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "detachValidValueFromSet");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "detachValidValueFromSet");
        this.restClient.callVoidPostRESTCall("detachValidValueFromSet", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, setGUID, validValueGUID});
    }

    public ValidValueElement getValidValueByGUID(String userId, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByGUID";
        String validValueGUIDParameter = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByGUID");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValueByGUID");
        ValidValueResponse restResult = this.restClient.callValidValueGetRESTCall("getValidValueByGUID", urlTemplate, this.serverName, userId, validValueGUID);
        return restResult.getElement();
    }

    public List<ValidValueElement> getValidValueByName(String userId, String validValueName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByName";
        String validValueNameParameter = "validValueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/by-name?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByName");
        this.invalidParameterHandler.validateName(validValueName, "validValueName", "getValidValueByName");
        ValidValuesResponse restResult = this.restClient.callValidValuesPostRESTCall("getValidValueByName", urlTemplate, validValueName, this.serverName, userId, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> findValidValues(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByName";
        String parameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/by-search-string?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByName");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "getValidValueByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueByName");
        ValidValuesResponse restResult = this.restClient.callValidValuesPostRESTCall("getValidValueByName", urlTemplate, searchString, this.serverName, userId, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getValidValueSetMembers(String userId, String validValueSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueSetMembers";
        String validValueGUIDParameter = "validValueSetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/sets/{2}/members?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueSetMembers");
        this.invalidParameterHandler.validateGUID(validValueSetGUID, "validValueSetGUID", "getValidValueSetMembers");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueSetMembers");
        ValidValuesResponse restResult = this.restClient.callValidValuesGetRESTCall("getValidValueSetMembers", urlTemplate, this.serverName, userId, validValueSetGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<ValidValueElement> getSetsForValidValue(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForValidValue";
        String validValueGUIDParameter = "validValueSetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/valid-values/{2}/set-membership?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueSetGUID", "getSetsForValidValue");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSetsForValidValue");
        ValidValuesResponse restResult = this.restClient.callValidValuesGetRESTCall("getSetsForValidValue", urlTemplate, this.serverName, userId, validValueGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }
}

