/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingCSVFileInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewCSVFileAssetRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CSVFileAssetOwner
extends AssetOwner
implements AssetOnboardingCSVFileInterface {
    public CSVFileAssetOwner(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public CSVFileAssetOwner(String serverName, String serverPlatformURLRoot, AssetOwnerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.addCSVFileToCatalog(userId, displayName, description, fullPath, null, null, null);
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCSVFileToCatalog";
        String pathParameter = "fullPath";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files/csv";
        this.invalidParameterHandler.validateUserId(userId, "addCSVFileToCatalog");
        this.invalidParameterHandler.validateName(fullPath, "fullPath", "addCSVFileToCatalog");
        NewCSVFileAssetRequestBody requestBody = new NewCSVFileAssetRequestBody();
        requestBody.setName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(fullPath);
        requestBody.setColumnHeaders(columnHeaders);
        requestBody.setDelimiterCharacter(delimiterCharacter);
        requestBody.setQuoteCharacter(quoteCharacter);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addCSVFileToCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUIDs();
    }
}

