/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.fvt.assets;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateAssetTest {
    private static final String testCaseName = "CreateAssetTest";
    private static final int maxPageSize = 100;
    private static final String assetName = "TestAsset qualifiedName";
    private static final String assetDisplayName = "Asset displayName";
    private static final String assetDescription = "Asset description";
    private static final String assetAdditionalPropertyName = "TestAsset additionalPropertyName";
    private static final String assetAdditionalPropertyValue = "TestAsset additionalPropertyValue";
    private static final String schemaTypeName = "SchemaType qualifiedNAme";
    private static final String schemaTypeDisplayName = "SchemaType displayName";
    private static final String schemaTypeDescription = "SchemaType description";
    private static final String schemaTypeType = "SchemaType type";
    private static final String schemaTypeDefaultValue = "SchemaType defaultValue";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateAssetTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateAssetTest thisTest = new CreateAssetTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceWiki());
        AssetOwner client = thisTest.getAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        String assetGUID = thisTest.getAsset(client, userId);
        String schemaTypeGUID = thisTest.getSchemaType(client, assetGUID, userId);
    }

    private AssetOwner getAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetOwnerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            return new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetOwnerClient", unexpectedError);
        }
    }

    private String getAsset(AssetOwner client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getAsset";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(assetAdditionalPropertyName, assetAdditionalPropertyValue);
            AssetProperties properties = new AssetProperties();
            properties.setTypeName("Asset");
            properties.setQualifiedName(assetName);
            properties.setDisplayName(assetDisplayName);
            properties.setDescription(assetDescription);
            properties.setAdditionalProperties(additionalProperties);
            String assetGUID = client.addAssetToCatalog(userId, properties);
            if (assetGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(no GUID for Create)");
            }
            AssetElement retrievedElement = client.getAssetSummary(userId, assetGUID);
            AssetProperties retrievedAsset = retrievedElement.getAssetProperties();
            if (retrievedAsset == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(no SchemaType from Retrieve)");
            }
            if (!assetName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Bad qualifiedName from Retrieve)");
            }
            if (!assetDisplayName.equals(retrievedAsset.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Bad displayName from Retrieve)");
            }
            if (!assetDescription.equals(retrievedAsset.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Bad description from Retrieve)");
            }
            if (retrievedAsset.getAdditionalProperties() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(null additionalProperties from Retrieve)");
            }
            if (!assetAdditionalPropertyValue.equals(retrievedAsset.getAdditionalProperties().get(assetAdditionalPropertyName))) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(bad additionalProperties from Retrieve)");
            }
            List assetList = client.getAssetsByName(userId, assetName, 0, 100);
            if (assetList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(no Asset for RetrieveByName)");
            }
            if (assetList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Empty Asset list for RetrieveByName)");
            }
            if (assetList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Asset list for RetrieveByName contains" + assetList.size() + " elements)");
            }
            retrievedElement = (AssetElement)assetList.get(0);
            retrievedAsset = retrievedElement.getAssetProperties();
            if (!assetName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Bad qualifiedName from RetrieveByName)");
            }
            if (!assetDisplayName.equals(retrievedAsset.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Bad displayName from RetrieveByName)");
            }
            if (!assetDescription.equals(retrievedAsset.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(Bad description from RetrieveByName)");
            }
            if (retrievedAsset.getAdditionalProperties() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(null additionalProperties from Retrieve)");
            }
            if (!assetAdditionalPropertyValue.equals(retrievedAsset.getAdditionalProperties().get(assetAdditionalPropertyName))) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(bad additionalProperties from Retrieve)");
            }
            return assetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAsset", unexpectedError);
        }
    }

    private String getSchemaType(AssetOwner client, String assetGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getSchemaType";
        try {
            PrimitiveSchemaTypeProperties properties = new PrimitiveSchemaTypeProperties();
            properties.setQualifiedName(schemaTypeName);
            properties.setDisplayName(schemaTypeDisplayName);
            properties.setDescription(schemaTypeDescription);
            properties.setDataType(schemaTypeType);
            properties.setDefaultValue(schemaTypeDefaultValue);
            properties.setTypeName("PrimitiveSchemaType");
            String schemaTypeGUID = client.addSchemaTypeToAsset(userId, assetGUID, (SchemaTypeProperties)properties);
            if (schemaTypeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(no GUID for Create)");
            }
            return schemaTypeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getSchemaType", unexpectedError);
        }
    }
}

