/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.AvroFileAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.CSVFileAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.FileSystemAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.ValidValuesAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceWiki());
        thisTest.testAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testAvroFileAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testCSVFileAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testFileSystemAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testValidValuesAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new AssetOwner(serverName, serverPlatformRootURL, auditLog);
        new AssetOwner(serverName, serverPlatformRootURL);
        new AssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new AssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
        new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testAvroFileAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new AvroFileAssetOwner(serverName, serverPlatformRootURL, auditLog);
        new AvroFileAssetOwner(serverName, serverPlatformRootURL);
        new AvroFileAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new AvroFileAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
        new AvroFileAssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testCSVFileAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new CSVFileAssetOwner(serverName, serverPlatformRootURL, auditLog);
        new CSVFileAssetOwner(serverName, serverPlatformRootURL);
        new CSVFileAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new CSVFileAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
        new CSVFileAssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testFileSystemAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new FileSystemAssetOwner(serverName, serverPlatformRootURL, auditLog);
        new FileSystemAssetOwner(serverName, serverPlatformRootURL);
        new FileSystemAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new FileSystemAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
        new FileSystemAssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testValidValuesAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new ValidValuesAssetOwner(serverName, serverPlatformRootURL, auditLog);
        new ValidValuesAssetOwner(serverName, serverPlatformRootURL);
        new ValidValuesAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new ValidValuesAssetOwner(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
        new ValidValuesAssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }
}

