/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.assetowner.client.ValidValuesAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceWiki());
        thisTest.testValidValuesManagerClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testValidValuesManagerClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testValidValuesManagerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            ValidValuesAssetOwner client = new ValidValuesAssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testCreateValidValuesSet(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testValidValuesManagerClient", (Throwable)unexpectedError);
        }
    }

    private void testCreateValidValuesSet(String userId, ValidValuesAssetOwner client) throws FVTUnexpectedCondition {
        String activityName = "testCreateValidValuesSet";
        try {
            this.testCreateValidValuesSetNoUserId(client);
            this.testCreateValidValuesSetNoProperties(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSet", (Throwable)unexpectedError);
        }
    }

    private void testCreateValidValuesSetNoUserId(ValidValuesAssetOwner client) throws FVTUnexpectedCondition {
        String activityName = "testCreateValidValuesSetNoUserId";
        try {
            client.createValidValueSet(null, null, null, null, null, null, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSetNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSetNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateValidValuesSetNoProperties(ValidValuesAssetOwner client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateValidValuesSetNoProperties";
        try {
            client.createValidValueSet(userId, null, null, null, null, null, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSetNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSetNoProperties", (Throwable)unexpectedError);
        }
    }
}

