/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.fvt.dataassets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateDatabaseTest {
    private static final String testCaseName = "CreateDatabaseTest";
    private static final int maxPageSize = 100;
    private static final String databaseName = "TestDatabase";
    private static final String databaseDisplayName = "Database displayName";
    private static final String databaseDescription = "Database description";
    private static final String databaseType = "Database type";
    private static final String databaseVersion = "Database version";
    private static final String databaseSchemaName = "TestDatabaseSchema";
    private static final String databaseSchemaDisplayName = "DatabaseSchema displayName";
    private static final String databaseSchemaDescription = "DatabaseSchema description";
    private static final String databaseTableName = "TestDatabaseTable";
    private static final String databaseTableDisplayName = "DatabaseTable displayName";
    private static final String databaseTableDescription = "DatabaseTable description";
    private static final String databaseColumnName = "TestDatabaseColumn";
    private static final String databaseColumnDisplayName = "DatabaseColumn displayName";
    private static final String databaseColumnDescription = "DatabaseColumn description";
    private static final String databaseColumnType = "string";
    private static final String databaseColumnTwoName = "TestDatabaseColumn2";
    private static final String databaseColumnTwoDisplayName = "DatabaseColumn2 displayName";
    private static final String databaseColumnTwoDescription = "DatabaseColumn2 description";
    private static final String databaseColumnTwoType = "date";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateDatabaseTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateDatabaseTest thisTest = new CreateDatabaseTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceWiki());
        AssetOwner client = thisTest.getAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        String databaseGUID = thisTest.getDatabase(client, userId);
        String databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseGUID, userId);
        String databaseTableGUID = thisTest.createDatabaseTable(client, databaseSchemaGUID, userId);
        String databaseColumnGUID = thisTest.createDatabaseColumn(client, databaseSchemaGUID, databaseTableGUID, userId);
        Object activityName = "cascadedDelete - remove Database";
        System.out.println("activityName = " + (String)activityName);
        System.out.println("databaseGUID = " + databaseGUID);
        System.out.println("databaseSchemaGUID = " + databaseSchemaGUID);
        System.out.println("databaseTableGUID = " + databaseTableGUID);
        System.out.println("databaseColumnGUID = " + databaseColumnGUID);
        try {
            client.deleteAsset(userId, databaseGUID);
            thisTest.checkDatabaseGone(client, databaseGUID, (String)activityName, userId);
            thisTest.checkDatabaseColumnOK(client, databaseColumnGUID, databaseTableGUID, (String)activityName, userId);
            thisTest.checkDatabaseTableOK(client, databaseTableGUID, (String)activityName, userId);
            thisTest.checkDatabaseSchemaOK(client, databaseSchemaGUID, null, (String)activityName, userId);
            activityName = "cascadedDelete - remove DatabaseSchema";
            client.deleteAsset(userId, databaseSchemaGUID);
            thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, null, (String)activityName, userId);
            thisTest.checkDatabaseTableGone(client, databaseTableGUID, (String)activityName, userId);
            thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, (String)activityName, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, (String)activityName, (Throwable)unexpectedError);
        }
        activityName = "deleteOneByOne";
        System.out.println("activityName = " + (String)activityName);
        databaseGUID = thisTest.getDatabase(client, userId);
        databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseGUID, userId);
        databaseTableGUID = thisTest.createDatabaseTable(client, databaseSchemaGUID, userId);
        databaseColumnGUID = thisTest.createDatabaseColumn(client, databaseSchemaGUID, databaseTableGUID, userId);
        System.out.println("databaseGUID = " + databaseGUID);
        System.out.println("databaseSchemaGUID = " + databaseSchemaGUID);
        System.out.println("databaseTableGUID = " + databaseTableGUID);
        System.out.println("databaseColumnGUID = " + databaseColumnGUID);
        try {
            activityName = "deleteOneByOne - pre-validate";
            thisTest.checkDatabaseColumnOK(client, databaseColumnGUID, databaseTableGUID, (String)activityName, userId);
            thisTest.checkDatabaseTableOK(client, databaseTableGUID, (String)activityName, userId);
            thisTest.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, (String)activityName, userId);
            thisTest.checkDatabaseOK(client, databaseGUID, (String)activityName, userId);
            client.removeSchemaAttribute(userId, databaseColumnGUID);
            activityName = "deleteOneByOne - column gone";
            thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, databaseTableGUID, (String)activityName, userId);
            activityName = "deleteOneByOne - column gone - check table: " + databaseTableGUID;
            thisTest.checkDatabaseTableOK(client, databaseTableGUID, (String)activityName, userId);
            activityName = "deleteOneByOne - column gone - check schema";
            thisTest.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, (String)activityName, userId);
            activityName = "deleteOneByOne - column gone - check DB";
            thisTest.checkDatabaseOK(client, databaseGUID, (String)activityName, userId);
            activityName = "deleteOneByOne - remove table";
            client.removeSchemaAttribute(userId, databaseTableGUID);
            activityName = "deleteOneByOne - table gone";
            thisTest.checkDatabaseTableGone(client, databaseTableGUID, (String)activityName, userId);
            thisTest.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, (String)activityName, userId);
            thisTest.checkDatabaseOK(client, databaseGUID, (String)activityName, userId);
            client.deleteAsset(userId, databaseSchemaGUID);
            activityName = "deleteOneByOne - schema gone";
            thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, databaseGUID, (String)activityName, userId);
            thisTest.checkDatabaseOK(client, databaseGUID, (String)activityName, userId);
            client.deleteAsset(userId, databaseGUID);
            activityName = "deleteOneByOne - database gone";
            thisTest.checkDatabaseGone(client, databaseGUID, (String)activityName, userId);
            activityName = "deleteOneByOne";
            databaseGUID = thisTest.getDatabase(client, userId);
            databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseGUID, userId);
            databaseTableGUID = thisTest.createDatabaseTable(client, databaseSchemaGUID, userId);
            databaseColumnGUID = thisTest.createDatabaseColumn(client, databaseSchemaGUID, databaseTableGUID, userId);
            System.out.println("databaseGUID = " + databaseGUID);
            System.out.println("databaseSchemaGUID = " + databaseSchemaGUID);
            System.out.println("databaseTableGUID = " + databaseTableGUID);
            System.out.println("databaseColumnGUID = " + databaseColumnGUID);
            activityName = "updateNonExistentColumn";
            String databaseColumnTwoGUID = "Blah Blah";
            SchemaAttributeProperties databaseColumnTwoProperties = new SchemaAttributeProperties();
            databaseColumnTwoProperties.setQualifiedName(databaseColumnTwoName);
            databaseColumnTwoProperties.setDisplayName(databaseColumnDisplayName);
            databaseColumnTwoProperties.setDescription(databaseColumnTwoDescription);
            SchemaTypeProperties attributeType = new SchemaTypeProperties();
            attributeType.setTypeName("PrimitiveSchemaType");
            databaseColumnTwoProperties.setAttributeType(attributeType);
            try {
                client.updateSchemaAttribute(userId, databaseColumnTwoGUID, true, databaseColumnTwoProperties);
                throw new FVTUnexpectedCondition(testCaseName, (String)activityName);
            }
            catch (InvalidParameterException invalidParameterException) {
                activityName = "updateColumnWithSameProperties";
                databaseColumnTwoGUID = client.addSchemaAttribute(userId, databaseSchemaGUID, databaseTableGUID, databaseColumnTwoProperties);
                SchemaAttributeElement beforeElement = client.getSchemaAttributeByGUID(userId, databaseColumnTwoGUID);
                client.updateSchemaAttribute(userId, databaseColumnTwoGUID, true, databaseColumnTwoProperties);
                SchemaAttributeElement afterElement = client.getSchemaAttributeByGUID(userId, databaseColumnTwoGUID);
                if (!beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, (String)activityName + "(version changed from " + beforeElement.getElementHeader().getVersions() + " to " + afterElement.getElementHeader().getVersions() + ")");
                }
                activityName = "updateColumnClassificationProperties";
                SchemaTypeProperties schemaType = new SchemaTypeProperties();
                HashMap<String, String> extendedProperties = new HashMap<String, String>();
                extendedProperties.put("dataType", databaseColumnTwoType);
                schemaType.setExtendedProperties(extendedProperties);
                databaseColumnTwoProperties.setAttributeType(schemaType);
                client.updateSchemaAttribute(userId, databaseColumnTwoGUID, true, databaseColumnTwoProperties);
                afterElement = client.getSchemaAttributeByGUID(userId, databaseColumnTwoGUID);
                if (!beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, (String)activityName + "(version changed from " + beforeElement.getElementHeader().getVersions() + " to " + afterElement.getElementHeader().getVersions() + ")");
                }
                Object dataType = afterElement.getSchemaAttributeProperties().getAttributeType().getExtendedProperties().get("dataType");
                if (!databaseColumnTwoType.equals(dataType)) {
                    throw new FVTUnexpectedCondition(testCaseName, (String)activityName + "(data type should be date rather than " + dataType + "). Returned element: " + afterElement);
                }
                activityName = "updateColumnProperties";
                databaseColumnTwoProperties.setDisplayName(databaseColumnTwoDisplayName);
                client.updateSchemaAttribute(userId, databaseColumnTwoGUID, true, databaseColumnTwoProperties);
                afterElement = client.getSchemaAttributeByGUID(userId, databaseColumnTwoGUID);
                if (beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, (String)activityName + "(version did not change from " + beforeElement.getElementHeader().getVersions() + ")");
                }
                if (!databaseColumnTwoDisplayName.equals(afterElement.getSchemaAttributeProperties().getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, (String)activityName + "(display name should be DatabaseColumn2 displayName rather than " + afterElement.getSchemaAttributeProperties().getDisplayName() + ")");
                }
                activityName = "cascadedDelete";
                try {
                    client.deleteAsset(userId, databaseGUID);
                    thisTest.checkDatabaseGone(client, databaseGUID, (String)activityName, userId);
                    client.deleteAsset(userId, databaseSchemaGUID);
                    thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, null, (String)activityName, userId);
                    thisTest.checkDatabaseTableGone(client, databaseTableGUID, (String)activityName, userId);
                    thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, (String)activityName, userId);
                    thisTest.checkDatabaseColumnGone(client, databaseColumnTwoGUID, null, (String)activityName, userId);
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, (String)activityName, (Throwable)unexpectedError);
                }
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, (String)activityName, (Throwable)unexpectedError);
        }
    }

    private AssetOwner getAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetOwnerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            return new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetOwnerClient", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseGone(AssetOwner client, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            AssetElement retrievedElement = client.getAssetSummary(userId, databaseGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Database returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Retrieve returned)");
        }
        catch (InvalidParameterException retrievedElement) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseOK(AssetOwner client, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            AssetElement retrievedElement = client.getAssetSummary(userId, databaseGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseElement from Retrieve)");
            }
            AssetProperties retrievedDatabase = retrievedElement.getAssetProperties();
            if (retrievedDatabase == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseProperties from Retrieve)");
            }
            if (!databaseName.equals(retrievedDatabase.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!databaseDisplayName.equals(retrievedDatabase.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!databaseDescription.equals(retrievedDatabase.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            Map databaseExtendedProperties = retrievedDatabase.getExtendedProperties();
            if (!databaseType.equals(databaseExtendedProperties.get("deployedImplementationType"))) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseType from Retrieve).  Retrieve Element: " + retrievedDatabase);
            }
            if (!databaseVersion.equals(databaseExtendedProperties.get("databaseVersion"))) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseVersion from Retrieve).  Retrieve Element: " + retrievedDatabase);
            }
            List databaseList = client.getAssetsByName(userId, databaseName, 0, 100);
            if (databaseList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Database for RetrieveByName)");
            }
            if (databaseList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Database list for RetrieveByName)");
            }
            if (databaseList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Database list for RetrieveByName contains" + databaseList.size() + " elements)");
            }
            retrievedElement = (AssetElement)databaseList.get(0);
            retrievedDatabase = retrievedElement.getAssetProperties();
            if (!databaseName.equals(retrievedDatabase.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseDisplayName.equals(retrievedDatabase.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!databaseDescription.equals(retrievedDatabase.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            databaseExtendedProperties = retrievedDatabase.getExtendedProperties();
            if (!databaseType.equals(databaseExtendedProperties.get("deployedImplementationType"))) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseType from RetrieveByName).  Retrieve Element: " + retrievedDatabase);
            }
            if (!databaseVersion.equals(databaseExtendedProperties.get("databaseVersion"))) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseVersion from RetrieveByName).  Retrieve Element: " + retrievedDatabase);
            }
            databaseList = client.getAssetsByName(userId, databaseName, 1, 100);
            if (databaseList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Database for RetrieveByName)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getDatabase(AssetOwner client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabase";
        try {
            AssetProperties properties = new AssetProperties();
            properties.setQualifiedName(databaseName);
            properties.setDisplayName(databaseDisplayName);
            properties.setDescription(databaseDescription);
            properties.setTypeName("Database");
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("deployedImplementationType", databaseType);
            extendedProperties.put("databaseVersion", databaseVersion);
            properties.setExtendedProperties(extendedProperties);
            String databaseGUID = client.addAssetToCatalog(userId, properties);
            if (databaseGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(no GUID for Create)");
            }
            this.checkDatabaseOK(client, databaseGUID, "getDatabase", userId);
            return databaseGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabase", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseSchemaGone(AssetOwner client, String databaseSchemaGUID, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            AssetElement retrievedElement = client.getAssetSummary(userId, databaseSchemaGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseSchema returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getDatabaseSchemaByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (databaseGUID != null) {
            try {
                List relationshipList = client.getRelatedAssetsAtEnd2(userId, "DataContentForDataSet", databaseGUID, 0, 100);
                if (relationshipList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(No DatabaseSchema returned for getSchemasForDatabase)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkDatabaseSchemaOK(AssetOwner client, String databaseSchemaGUID, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            AssetElement retrievedElement = client.getAssetSummary(userId, databaseSchemaGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchemaElement from Retrieve)");
            }
            this.validateAnchorGUID(activityName, (MetadataElement)retrievedElement);
            AssetProperties retrievedSchema = retrievedElement.getAssetProperties();
            if (retrievedSchema == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchemaProperties from Retrieve)");
            }
            if (!databaseSchemaName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!databaseSchemaDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!databaseSchemaDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            List databaseSchemaList = client.getAssetsByName(userId, databaseSchemaName, 0, 100);
            if (databaseSchemaList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchema for RetrieveByName)");
            }
            if (databaseSchemaList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseSchema list for RetrieveByName)");
            }
            if (databaseSchemaList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseSchema list for RetrieveByName contains" + databaseSchemaList.size() + " elements)");
            }
            retrievedElement = (AssetElement)databaseSchemaList.get(0);
            retrievedSchema = retrievedElement.getAssetProperties();
            if (!databaseSchemaName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseSchemaDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!databaseSchemaDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            if (databaseGUID != null) {
                List relationshipElements = client.getRelatedAssetsAtEnd2(userId, "DataContentForDataSet", databaseGUID, 0, 100);
                if (relationshipElements == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchema for getSchemasForDatabase)");
                }
                if (databaseSchemaList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseSchema list for getSchemasForDatabase)");
                }
                if (databaseSchemaList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseSchema list for getSchemasForDatabase contains" + databaseSchemaList.size() + " elements)");
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getDatabaseSchema(AssetOwner client, String databaseGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseSchema";
        try {
            AssetProperties properties = new AssetProperties();
            properties.setQualifiedName(databaseSchemaName);
            properties.setDisplayName(databaseSchemaDisplayName);
            properties.setDescription(databaseSchemaDescription);
            properties.setTypeName("DeployedDatabaseSchema");
            String databaseSchemaGUID = client.addAssetToCatalog(userId, properties);
            client.setupRelatedAsset(userId, "DataContentForDataSet", databaseGUID, databaseSchemaGUID, null);
            if (databaseSchemaGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(no GUID for schemaCreate)");
            }
            this.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, "getDatabaseSchema", userId);
            return databaseSchemaGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseTableGone(AssetOwner client, String databaseTableGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, databaseTableGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseTable returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getDatabaseTableByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseTableOK(AssetOwner client, String databaseTableGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, databaseTableGUID);
            this.validateDatabaseTable(activityName + "(getSchemaAttributeByGUID)", retrievedElement);
            List databaseTableList = client.getSchemaAttributesByName(userId, databaseTableName, 0, 100);
            this.validateDatabaseTableList(activityName + "(getSchemaAttributesByName)", databaseTableList);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void validateDatabaseTableList(String activityName, List<SchemaAttributeElement> databaseTableList) throws FVTUnexpectedCondition {
        if (databaseTableList == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - no DatabaseTable");
        }
        if (databaseTableList.isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Empty DatabaseTable list");
        }
        if (databaseTableList.size() != 1) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - DatabaseTable list contains " + databaseTableList.size() + " elements)");
        }
        this.validateDatabaseTable(activityName, databaseTableList.get(0));
    }

    private void validateDatabaseTable(String activityName, SchemaAttributeElement retrievedElement) throws FVTUnexpectedCondition {
        if (retrievedElement == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - no DatabaseTableElement");
        }
        System.out.println("Database Table: " + retrievedElement);
        SchemaAttributeProperties retrievedTable = retrievedElement.getSchemaAttributeProperties();
        if (retrievedTable == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - no DatabaseTableProperties");
        }
        if (!databaseTableName.equals(retrievedTable.getQualifiedName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad qualifiedName: " + retrievedTable.getQualifiedName() + " rather than TestDatabaseTable");
        }
        if (!databaseTableDisplayName.equals(retrievedTable.getDisplayName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad displayName: " + retrievedTable.getDisplayName() + " rather than DatabaseTable displayName");
        }
        if (!databaseTableDescription.equals(retrievedTable.getDescription())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad description: " + retrievedTable.getDescription() + " rather than DatabaseTable description");
        }
        this.validateAnchorGUID(activityName, (MetadataElement)retrievedElement);
    }

    private String createDatabaseTable(AssetOwner client, String databaseSchemaGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createDatabaseTable";
        try {
            SchemaTypeProperties schemaTypeProperties = new SchemaTypeProperties();
            schemaTypeProperties.setTypeName("RelationalDBSchemaType");
            schemaTypeProperties.setQualifiedName("SchemaOf:TestDatabaseSchema");
            String databaseSchemaTypeGUID = client.createAnchoredSchemaType(userId, databaseSchemaGUID, schemaTypeProperties);
            client.setupSchemaTypeParent(userId, databaseSchemaTypeGUID, databaseSchemaGUID, "Asset", null);
            SchemaAttributeProperties properties = new SchemaAttributeProperties();
            properties.setQualifiedName(databaseTableName);
            properties.setDisplayName(databaseTableDisplayName);
            properties.setDescription(databaseTableDescription);
            properties.setTypeName("RelationalTable");
            SchemaTypeProperties attributeType = new SchemaTypeProperties();
            attributeType.setTypeName("RelationalTableType");
            properties.setAttributeType(attributeType);
            String databaseTableGUID = client.addSchemaAttribute(userId, databaseSchemaGUID, databaseSchemaTypeGUID, properties);
            if (databaseTableGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTable(no GUID for tableCreate)");
            }
            this.checkDatabaseTableOK(client, databaseTableGUID, "createDatabaseTable", userId);
            return databaseTableGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTable", (Throwable)unexpectedError);
        }
    }

    private String createDatabaseTableForSchemaType(AssetOwner client, String databaseSchemaGUID, String databaseSchemaTypeGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createDatabaseTableForSchemaType";
        try {
            SchemaAttributeProperties properties = new SchemaAttributeProperties();
            properties.setQualifiedName(databaseTableName);
            properties.setDisplayName(databaseTableDisplayName);
            properties.setDescription(databaseTableDescription);
            properties.setTypeName("RelationalTable");
            SchemaTypeProperties attributeType = new SchemaTypeProperties();
            attributeType.setTypeName("RelationalTableType");
            properties.setAttributeType(attributeType);
            String databaseTableGUID = client.addSchemaAttribute(userId, databaseSchemaGUID, databaseSchemaTypeGUID, properties);
            if (databaseTableGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTableForSchemaType(no GUID for tableCreate)");
            }
            this.checkDatabaseTableOK(client, databaseTableGUID, "createDatabaseTableForSchemaType", userId);
            return databaseTableGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTableForSchemaType", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseColumnGone(AssetOwner client, String databaseColumnGUID, String databaseTableGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, databaseColumnGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getDatabaseColumnByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (databaseTableGUID != null) {
            try {
                List databaseColumnList = client.getNestedSchemaAttributes(userId, databaseTableGUID, 0, 100);
                if (databaseColumnList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn returned for getColumnsForDatabaseTable)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkDatabaseColumnOK(AssetOwner client, String databaseColumnGUID, String databaseTableGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, databaseColumnGUID);
            this.validateColumn(activityName + "(getSchemaAttributeByGUID)", retrievedElement);
            List databaseColumnList = client.getSchemaAttributesByName(userId, databaseColumnName, 0, 100);
            this.validateColumnList(activityName + "(getSchemaAttributesByName)", databaseColumnList);
            databaseColumnList = client.getNestedSchemaAttributes(userId, databaseTableGUID, 0, 100);
            this.validateColumnList(activityName + "(getColumnsForDatabaseTable)", databaseColumnList);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void validateColumnList(String activityName, List<SchemaAttributeElement> databaseColumnList) throws FVTUnexpectedCondition {
        if (databaseColumnList == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "- no DatabaseColumn List");
        }
        if (databaseColumnList.isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Empty DatabaseColumn list");
        }
        if (databaseColumnList.size() != 1) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn list contains" + databaseColumnList.size() + " elements)");
        }
        this.validateColumn(activityName, databaseColumnList.get(0));
    }

    private void validateColumn(String activityName, SchemaAttributeElement retrievedElement) throws FVTUnexpectedCondition {
        if (retrievedElement == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "- no DatabaseColumnElement");
        }
        System.out.println("Database Column: " + retrievedElement);
        SchemaAttributeProperties retrievedColumn = retrievedElement.getSchemaAttributeProperties();
        if (retrievedColumn == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "- no DatabaseColumnProperties");
        }
        if (!databaseColumnName.equals(retrievedColumn.getQualifiedName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad qualifiedName: " + retrievedColumn.getQualifiedName() + " rather than TestDatabaseColumn");
        }
        if (!databaseColumnDisplayName.equals(retrievedColumn.getDisplayName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad displayName: " + retrievedColumn.getDisplayName() + " rather than DatabaseColumn displayName");
        }
        if (!databaseColumnDescription.equals(retrievedColumn.getDescription())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad description: " + retrievedColumn.getDescription() + " rather than DatabaseColumn description");
        }
        this.validateAnchorGUID(activityName, (MetadataElement)retrievedElement);
    }

    private String createDatabaseColumn(AssetOwner client, String databaseSchemaGUID, String databaseTableGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createDatabaseColumn";
        try {
            SchemaAttributeProperties properties = new SchemaAttributeProperties();
            properties.setQualifiedName(databaseColumnName);
            properties.setDisplayName(databaseColumnDisplayName);
            properties.setDescription(databaseColumnDescription);
            properties.setTypeName("RelationalColumn");
            SchemaTypeProperties schemaTypeProperties = new SchemaTypeProperties();
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("dataType", databaseColumnType);
            schemaTypeProperties.setTypeName("PrimitiveSchemaType");
            schemaTypeProperties.setQualifiedName("SchemaType:TestDatabaseColumn");
            schemaTypeProperties.setExtendedProperties(extendedProperties);
            properties.setAttributeType(schemaTypeProperties);
            String databaseColumnGUID = client.addSchemaAttribute(userId, databaseSchemaGUID, databaseTableGUID, properties);
            if (databaseColumnGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createDatabaseColumn(no GUID for columnCreate)");
            }
            this.checkDatabaseColumnOK(client, databaseColumnGUID, databaseTableGUID, "createDatabaseColumn", userId);
            return databaseColumnGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createDatabaseColumn", (Throwable)unexpectedError);
        }
    }

    private void validateAnchorGUID(String activityName, MetadataElement metadataElement) {
        if (metadataElement.getElementHeader() != null && metadataElement.getElementHeader().getClassifications() != null) {
            for (ElementClassification classification : metadataElement.getElementHeader().getClassifications()) {
                if (!"Anchors".equals(classification.getClassificationName())) continue;
                System.out.println(metadataElement.getElementHeader().getType().getTypeName() + " element " + metadataElement.getElementHeader().getGUID() + " has anchor of " + classification.getClassificationProperties() + " in activity " + activityName);
            }
        }
    }
}

