/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.assetowner.fvt.assets.CreateAssetTest;
import org.odpi.openmetadata.accessservices.assetowner.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.assetowner.fvt.connections.CreateConnectionTest;
import org.odpi.openmetadata.accessservices.assetowner.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.accessservices.assetowner.fvt.validmetadatavalues.ValidMetadataValuesTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class AssetOwnerOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = AssetOwnerOMASFVTSuite.getUrl((String[])args);
            String serverName = AssetOwnerOMASFVTSuite.getServerName((String[])args);
            String userId = AssetOwnerOMASFVTSuite.getUserId((String[])args);
            AssetOwnerOMASFVTSuite fvtSuite = new AssetOwnerOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateAssetTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateConnectionTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = ValidMetadataValuesTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

