/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.fvt.assets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateAssetTest {
    private static final String testCaseName = "CreateAssetTest";
    private static final int maxPageSize = 100;
    private static final String assetQualifiedName = "TestAsset qualifiedName";
    private static final String assetFullQualifiedName = "TestAsset qualifiedName-full";
    private static final String assetResourceName = "Asset resourceName";
    private static final String assetVersionIdentifier = "Asset versionIdentifier";
    private static final String assetResourceDescription = "Asset resourceDescription";
    private static final String assetDisplayName = "Asset displayName";
    private static final String assetDisplayDescription = "Asset displayDescription";
    private static final String assetDisplaySummary = "Asset displaySummary";
    private static final String assetAbbreviation = "Asset abbreviation";
    private static final String assetUsage = "Asset usage";
    private static final String assetOriginPropertyName = "Asset origin";
    private static final String assetOriginPropertyValue = "Asset origin value";
    private static final String assetAdditionalPropertyName = "TestAsset additionalPropertyName";
    private static final String assetAdditionalPropertyValue = "TestAsset additionalPropertyValue";
    private static final String assetCopyResourceName = "Asset resourceName Copy";
    private static final String schemaTypeName = "SchemaType qualifiedNAme";
    private static final String schemaTypeDisplayName = "SchemaType displayName";
    private static final String schemaTypeDescription = "SchemaType description";
    private static final String schemaTypeType = "SchemaType type";
    private static final String schemaTypeDefaultValue = "SchemaType defaultValue";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateAssetTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateAssetTest thisTest = new CreateAssetTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceWiki());
        AssetOwner client = thisTest.getAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        String assetGUID = thisTest.getAsset(client, userId);
        String fullAssetGUID = thisTest.getFullAsset(client, userId);
        String schemaTypeGUID = thisTest.getSchemaType(client, assetGUID, userId);
        String copyAssetGUID = thisTest.getCopyAsset(client, fullAssetGUID, userId);
    }

    private AssetOwner getAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetOwnerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            return new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetOwnerClient", (Throwable)unexpectedError);
        }
    }

    private String getAsset(AssetOwner client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getAsset - create";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(assetAdditionalPropertyName, assetAdditionalPropertyValue);
            AssetProperties properties = new AssetProperties();
            properties.setTypeName("Asset");
            properties.setQualifiedName(assetQualifiedName);
            properties.setName(assetResourceName);
            properties.setResourceDescription(assetResourceDescription);
            properties.setAdditionalProperties(additionalProperties);
            String assetGUID = client.addAssetToCatalog(userId, properties);
            HashMap<String, String> otherOriginValues = new HashMap<String, String>();
            otherOriginValues.put(assetOriginPropertyName, assetOriginPropertyValue);
            client.addAssetOrigin(userId, assetGUID, null, null, otherOriginValues);
            this.validateAsset(client, userId, assetGUID, assetQualifiedName, assetResourceName, null, assetResourceDescription, additionalProperties, activityName);
            activityName = "getAsset - update";
            properties = new AssetProperties();
            properties.setVersionIdentifier(assetVersionIdentifier);
            properties.setDisplayName(assetDisplayName);
            properties.setDisplaySummary(assetDisplaySummary);
            properties.setDisplayDescription(assetDisplayDescription);
            properties.setAbbreviation(assetAbbreviation);
            properties.setUsage(assetUsage);
            client.updateAsset(userId, assetGUID, true, properties);
            this.validateAsset(client, userId, assetGUID, assetQualifiedName, assetResourceName, assetVersionIdentifier, assetResourceDescription, assetDisplayName, assetDisplaySummary, assetDisplayDescription, assetAbbreviation, assetUsage, additionalProperties, activityName);
            activityName = "getAsset - update 2";
            properties = new AssetProperties();
            properties.setTypeName("Asset");
            properties.setQualifiedName(assetQualifiedName);
            properties.setName("Asset resourceName - 2");
            properties.setResourceDescription("Asset resourceDescription - 2");
            properties.setDisplayName("Asset displayName - 2");
            properties.setDisplaySummary("Asset displaySummary - 2");
            properties.setDisplayDescription("Asset displayDescription - 2");
            properties.setAbbreviation("Asset abbreviation - 2");
            properties.setUsage("Asset usage - 2");
            client.updateAsset(userId, assetGUID, false, properties);
            this.validateAsset(client, userId, assetGUID, assetQualifiedName, "Asset resourceName - 2", null, "Asset resourceDescription - 2", "Asset displayName - 2", "Asset displaySummary - 2", "Asset displayDescription - 2", "Asset abbreviation - 2", "Asset usage - 2", null, activityName);
            return assetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getFullAsset(AssetOwner client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getFullAsset";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(assetAdditionalPropertyName, assetAdditionalPropertyValue);
            AssetProperties properties = new AssetProperties();
            properties.setTypeName("Asset");
            properties.setQualifiedName(assetFullQualifiedName);
            properties.setName(assetResourceName);
            properties.setVersionIdentifier(assetVersionIdentifier);
            properties.setResourceDescription(assetResourceDescription);
            properties.setDisplayName(assetDisplayName);
            properties.setDisplaySummary(assetDisplaySummary);
            properties.setDisplayDescription(assetDisplayDescription);
            properties.setAbbreviation(assetAbbreviation);
            properties.setUsage(assetUsage);
            properties.setAdditionalProperties(additionalProperties);
            String assetGUID = client.addAssetToCatalog(userId, properties);
            HashMap<String, String> otherOriginValues = new HashMap<String, String>();
            otherOriginValues.put(assetOriginPropertyName, assetOriginPropertyValue);
            client.addAssetOrigin(userId, assetGUID, null, null, otherOriginValues);
            this.validateAsset(client, userId, assetGUID, assetFullQualifiedName, assetResourceName, assetVersionIdentifier, assetResourceDescription, assetDisplayName, assetDisplaySummary, assetDisplayDescription, assetAbbreviation, assetUsage, additionalProperties, "getFullAsset");
            return assetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getFullAsset", (Throwable)unexpectedError);
        }
    }

    private void validateAsset(AssetOwner client, String userId, String assetGUID, String qualifiedName, String name, String versionIdentifier, String description, Map<String, String> additionalProperties, String activityName) throws FVTUnexpectedCondition {
        try {
            List assetList;
            if (assetGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for Create)");
            }
            AssetElement retrievedElement = client.getAssetSummary(userId, assetGUID);
            AssetProperties retrievedAsset = retrievedElement.getProperties();
            if (retrievedAsset == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no asset from Retrieve)");
            }
            if (!qualifiedName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!name.equals(retrievedAsset.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad name from Retrieve)");
            }
            if (versionIdentifier == null) {
                if (retrievedAsset.getVersionIdentifier() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Non-null versionIdentifier from Retrieve)");
                }
            } else if (!versionIdentifier.equals(retrievedAsset.getVersionIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad versionIdentifier from Retrieve)");
            }
            if (!description.equals(retrievedAsset.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            if (additionalProperties == null) {
                if (retrievedAsset.getAdditionalProperties() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(non-null additionalProperties from Retrieve)");
                }
            } else {
                if (retrievedAsset.getAdditionalProperties() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(null additionalProperties from Retrieve)");
                }
                if (!assetAdditionalPropertyValue.equals(retrievedAsset.getAdditionalProperties().get(assetAdditionalPropertyName))) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad additionalProperties from Retrieve)");
                }
            }
            if ((assetList = client.getAssetsByName(userId, qualifiedName, 0, 100)) == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Asset for RetrieveByName)");
            }
            if (assetList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Asset list for RetrieveByName)");
            }
            if (assetList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Asset list for RetrieveByName contains" + assetList.size() + " elements)");
            }
            retrievedElement = (AssetElement)assetList.get(0);
            retrievedAsset = retrievedElement.getProperties();
            if (!qualifiedName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!name.equals(retrievedAsset.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad name from RetrieveByName)");
            }
            if (versionIdentifier == null) {
                if (retrievedAsset.getVersionIdentifier() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Non-null versionIdentifier from RetrieveByName)");
                }
            } else if (!versionIdentifier.equals(retrievedAsset.getVersionIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad versionIdentifier from RetrieveByName)");
            }
            if (!description.equals(retrievedAsset.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            if (additionalProperties == null) {
                if (retrievedAsset.getAdditionalProperties() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(non-null additionalProperties from RetrieveByName)");
                }
            } else {
                if (retrievedAsset.getAdditionalProperties() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(null additionalProperties from RetrieveByName)");
                }
                if (!assetAdditionalPropertyValue.equals(retrievedAsset.getAdditionalProperties().get(assetAdditionalPropertyName))) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad additionalProperties from RetrieveByName)");
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void validateAsset(AssetOwner client, String userId, String assetGUID, String qualifiedName, String name, String versionIdentifier, String description, String displayName, String displaySummary, String displayDescription, String abbreviation, String usage, Map<String, String> additionalProperties, String activityName) throws FVTUnexpectedCondition {
        try {
            List assetList;
            if (assetGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for Create)");
            }
            AssetElement retrievedElement = client.getAssetSummary(userId, assetGUID);
            AssetProperties retrievedAsset = retrievedElement.getProperties();
            if (retrievedAsset == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no asset from Retrieve)");
            }
            if (!qualifiedName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!name.equals(retrievedAsset.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad name from Retrieve)");
            }
            if (versionIdentifier == null) {
                if (retrievedAsset.getVersionIdentifier() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Non-null versionIdentifier from Retrieve)");
                }
            } else if (!versionIdentifier.equals(retrievedAsset.getVersionIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad versionIdentifier from Retrieve)");
            }
            if (!description.equals(retrievedAsset.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            if (!displayName.equals(retrievedAsset.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName <" + retrievedAsset.getDisplayName() + "> from Retrieve)");
            }
            if (!displaySummary.equals(retrievedAsset.getDisplaySummary())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displaySummary from Retrieve)");
            }
            if (!displayDescription.equals(retrievedAsset.getDisplayDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayDescription from Retrieve)");
            }
            if (!abbreviation.equals(retrievedAsset.getAbbreviation())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad abbreviation from Retrieve)");
            }
            if (!usage.equals(retrievedAsset.getUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad usage from Retrieve)");
            }
            if (additionalProperties == null) {
                if (retrievedAsset.getAdditionalProperties() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(non-null additionalProperties from Retrieve)");
                }
            } else {
                if (retrievedAsset.getAdditionalProperties() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(null additionalProperties from Retrieve)");
                }
                if (!assetAdditionalPropertyValue.equals(retrievedAsset.getAdditionalProperties().get(assetAdditionalPropertyName))) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad additionalProperties from Retrieve)");
                }
            }
            if ((assetList = client.getAssetsByName(userId, qualifiedName, 0, 100)) == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Asset for RetrieveByName)");
            }
            if (assetList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Asset list for RetrieveByName)");
            }
            if (assetList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Asset list for RetrieveByName contains" + assetList.size() + " elements)");
            }
            retrievedElement = (AssetElement)assetList.get(0);
            retrievedAsset = retrievedElement.getProperties();
            if (!qualifiedName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!name.equals(retrievedAsset.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad name from RetrieveByName)");
            }
            if (versionIdentifier == null) {
                if (retrievedAsset.getVersionIdentifier() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Non-null versionIdentifier from RetrieveByName)");
                }
            } else if (!versionIdentifier.equals(retrievedAsset.getVersionIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad versionIdentifier from RetrieveByName)");
            }
            if (!description.equals(retrievedAsset.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            if (!displayName.equals(retrievedAsset.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!displaySummary.equals(retrievedAsset.getDisplaySummary())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displaySummary from RetrieveByName)");
            }
            if (!displayDescription.equals(retrievedAsset.getDisplayDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayDescription from RetrieveByName)");
            }
            if (!abbreviation.equals(retrievedAsset.getAbbreviation())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad abbreviation from RetrieveByName)");
            }
            if (!usage.equals(retrievedAsset.getUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad usage from RetrieveByName)");
            }
            if (additionalProperties == null) {
                if (retrievedAsset.getAdditionalProperties() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(non-null additionalProperties from RetrieveByName)");
                }
            } else {
                if (retrievedAsset.getAdditionalProperties() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(null additionalProperties from RetrieveByName)");
                }
                if (!assetAdditionalPropertyValue.equals(retrievedAsset.getAdditionalProperties().get(assetAdditionalPropertyName))) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad additionalProperties from RetrieveByName)");
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getSchemaType(AssetOwner client, String assetGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getSchemaType";
        try {
            SchemaTypeProperties properties = new SchemaTypeProperties();
            properties.setQualifiedName(schemaTypeName);
            properties.setDisplayName(schemaTypeDisplayName);
            properties.setDescription(schemaTypeDescription);
            properties.setTypeName("PrimitiveSchemaType");
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("dataType", schemaTypeType);
            extendedProperties.put("defaultValue", schemaTypeDefaultValue);
            properties.setExtendedProperties(extendedProperties);
            String schemaTypeGUID = client.addSchemaTypeToAsset(userId, assetGUID, properties);
            if (schemaTypeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(no GUID for CreateSchemaType)");
            }
            AssetUniverse assetUniverse = client.getAssetProperties(userId, assetGUID);
            if (assetUniverse == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(no asset universe for CreateSchemaType)");
            }
            SchemaType schemaType = assetUniverse.getRootSchemaType();
            if (schemaType == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(no schema type for CreateSchemaType)");
            }
            if (!schemaTypeGUID.equals(schemaType.getGUID())) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(wrong schema type GUID for CreateSchemaType - " + schemaType.getGUID() + "rather than" + schemaTypeGUID + ")");
            }
            if (!schemaTypeName.equals(schemaType.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(wrong qualifiedName for CreateSchemaType - " + schemaType.getQualifiedName() + "rather thanSchemaType qualifiedNAme)");
            }
            if (!schemaTypeDisplayName.equals(schemaType.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(wrong displayName for CreateSchemaType - " + schemaType.getDisplayName() + "rather thanSchemaType displayName)");
            }
            if (!schemaTypeDescription.equals(schemaType.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(wrong description for CreateSchemaType - " + schemaType.getDescription() + "rather thanSchemaType description)");
            }
            if (schemaType instanceof PrimitiveSchemaType) {
                PrimitiveSchemaType primitiveSchemaType = (PrimitiveSchemaType)schemaType;
                if (!schemaTypeType.equals(primitiveSchemaType.getDataType())) {
                    throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(wrong data type for CreateSchemaType - " + primitiveSchemaType.getDataType() + "rather thanSchemaType type)");
                }
            } else {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(wrong type for CreateSchemaType - " + schemaType.getClass().getName() + "rather than PrimitiveSchemaType)");
            }
            return schemaTypeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getSchemaType", (Throwable)unexpectedError);
        }
    }

    private String getCopyAsset(AssetOwner client, String assetGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getCopyAsset";
        try {
            TemplateProperties properties = new TemplateProperties();
            properties.setQualifiedName(assetCopyResourceName);
            String assetCopyGUID = client.addAssetToCatalogUsingTemplate(userId, assetGUID, properties);
            if (assetCopyGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getCopyAsset(no GUID for CreateByTemplate)");
            }
            return assetCopyGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getCopyAsset", (Throwable)unexpectedError);
        }
    }
}

