/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.fvt.dataassets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateSchemasTest {
    private static final String testCaseName = "CreateSchemaTest";
    private static final int maxPageSize = 100;
    private static final String assetName = "TestAsset";
    private static final String assetDisplayName = "Asset displayName";
    private static final String assetDescription = "Asset description";
    private static final String optionSchemaName = "TestSchemaTypeOption";
    private static final String optionSchemaDisplayName = "TestSchemaTypeOption displayName";
    private static final String optionSchemaDescription = "TestSchemaTypeOption description";
    private static final String primitive1Name = "TestPrimitive1";
    private static final String primitive1DisplayName = "TestPrimitive1 displayName";
    private static final String primitive1Description = "TestPrimitive1 description";
    private static final String primitive1DataType = "int";
    private static final String primitive2Name = "TestPrimitive2";
    private static final String primitive2DisplayName = "TestPrimitive2 displayName";
    private static final String primitive2Description = "TestPrimitive2 description";
    private static final String primitive2DataType = "string";
    private static final String mapName = "TestMap";
    private static final String mapDisplayName = "TestMap displayName";
    private static final String mapDescription = "TestMap description";
    private static final String primitiveFromName = "TestPrimitiveFrom";
    private static final String primitiveFromDisplayName = "TestPrimitiveFrom displayName";
    private static final String primitiveFromDescription = "TestPrimitiveFrom description";
    private static final String primitiveFromType = "date";
    private static final String primitiveToName = "TestPrimitiveTo";
    private static final String primitiveToDisplayName = "TestPrimitiveTo displayName";
    private static final String primitiveToDescription = "TestPrimitiveTo description";
    private static final String primitiveToType = "long";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateSchemasTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateSchemasTest thisTest = new CreateSchemasTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceWiki());
        AssetOwner client = thisTest.getAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        String assetGUID = thisTest.getAsset(client, userId);
        String primitive1GUID = thisTest.createPrimitive(client, assetGUID, userId, primitive1Name, primitive1DisplayName, primitive1Description, primitive1DataType);
        String primitive2GUID = thisTest.createPrimitive(client, assetGUID, userId, primitive2Name, primitive2DisplayName, primitive2Description, primitive2DataType);
        String primitiveFromGUID = thisTest.createPrimitive(client, assetGUID, userId, primitiveFromName, primitiveFromDisplayName, primitiveFromDescription, primitiveFromType);
        String primitiveToGUID = thisTest.createPrimitive(client, assetGUID, userId, primitiveToName, primitiveToDisplayName, primitiveToDescription, primitiveToType);
        String mapGUID = thisTest.createMap(client, assetGUID, userId, primitiveFromGUID, primitiveToGUID);
        ArrayList<String> optionGUIDs = new ArrayList<String>();
        optionGUIDs.add(primitive1GUID);
        optionGUIDs.add(primitive2GUID);
        optionGUIDs.add(mapGUID);
        String schemaOptionGUID = thisTest.getSchemaOption(client, assetGUID, userId, optionGUIDs);
        Object activityName = "cascadedDelete";
        System.out.println("activityName: " + (String)activityName);
        System.out.println("assetGUID: " + assetGUID);
        System.out.println("schemaOptionGUID: " + schemaOptionGUID);
        System.out.println("mapGUID: " + mapGUID);
        System.out.println("primitive1GUID: " + primitive1GUID);
        System.out.println("primitive2GUID: " + primitive2GUID);
        System.out.println("primitiveFromGUID: " + primitiveFromGUID);
        System.out.println("primitiveToGUID: " + primitiveToGUID);
        try {
            client.deleteAsset(userId, assetGUID);
            thisTest.checkAssetGone(client, assetGUID, (String)activityName, userId);
            thisTest.checkSchemaOptionGone(client, schemaOptionGUID, null, (String)activityName, userId);
            thisTest.checkMapGone(client, mapGUID, (String)activityName, userId);
            thisTest.checkPrimitiveGone(client, primitive1GUID, (String)activityName, userId);
            thisTest.checkPrimitiveGone(client, primitive2GUID, (String)activityName, userId);
            thisTest.checkPrimitiveGone(client, primitiveFromGUID, (String)activityName, userId);
            thisTest.checkPrimitiveGone(client, primitiveToGUID, (String)activityName, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, (String)activityName, (Throwable)unexpectedError);
        }
        activityName = "deleteOneByOne";
        assetGUID = thisTest.getAsset(client, userId);
        primitive1GUID = thisTest.createPrimitive(client, assetGUID, userId, primitive1Name, primitive1DisplayName, primitive1Description, primitive1DataType);
        primitive2GUID = thisTest.createPrimitive(client, assetGUID, userId, primitive2Name, primitive2DisplayName, primitive2Description, primitive2DataType);
        primitiveFromGUID = thisTest.createPrimitive(client, assetGUID, userId, primitiveFromName, primitiveFromDisplayName, primitiveFromDescription, primitiveFromType);
        primitiveToGUID = thisTest.createPrimitive(client, assetGUID, userId, primitiveToName, primitiveToDisplayName, primitiveToDescription, primitiveToType);
        mapGUID = thisTest.createMap(client, assetGUID, userId, primitiveFromGUID, primitiveToGUID);
        optionGUIDs = new ArrayList();
        optionGUIDs.add(primitive1GUID);
        optionGUIDs.add(primitive2GUID);
        optionGUIDs.add(mapGUID);
        schemaOptionGUID = thisTest.getSchemaOption(client, assetGUID, userId, optionGUIDs);
        System.out.println("activityName: " + (String)activityName);
        System.out.println("assetGUID: " + assetGUID);
        System.out.println("schemaOptionGUID: " + schemaOptionGUID);
        System.out.println("mapGUID: " + mapGUID);
        System.out.println("primitive1GUID: " + primitive1GUID);
        System.out.println("primitive2GUID: " + primitive2GUID);
        System.out.println("primitiveFromGUID: " + primitiveFromGUID);
        System.out.println("primitiveToGUID: " + primitiveToGUID);
        try {
            client.removeSchemaType(userId, primitive1GUID);
            activityName = "deleteOneByOne - primitive 1 gone";
            thisTest.checkPrimitiveGone(client, primitive1GUID, (String)activityName, userId);
            thisTest.checkPrimitiveOK(client, primitive2GUID, (String)activityName, userId, primitive2Name, primitive2DisplayName, primitive2Description, primitive2DataType);
            thisTest.checkPrimitiveOK(client, primitiveFromGUID, (String)activityName, userId, primitiveFromName, primitiveFromDisplayName, primitiveFromDescription, primitiveFromType);
            thisTest.checkPrimitiveOK(client, primitiveToGUID, (String)activityName, userId, primitiveToName, primitiveToDisplayName, primitiveToDescription, primitiveToType);
            thisTest.checkMapOK(client, mapGUID, (String)activityName, userId, primitiveFromGUID, primitiveToGUID);
            optionGUIDs = new ArrayList();
            optionGUIDs.add(primitive2GUID);
            optionGUIDs.add(mapGUID);
            thisTest.checkSchemaOptionOK(client, schemaOptionGUID, (String)activityName, userId, assetGUID, optionGUIDs);
            thisTest.checkAssetOK(client, assetGUID, (String)activityName, userId);
            client.removeSchemaType(userId, primitive2GUID);
            activityName = "deleteOneByOne - primitive 2 gone";
            thisTest.checkPrimitiveGone(client, primitive2GUID, (String)activityName, userId);
            thisTest.checkMapOK(client, mapGUID, (String)activityName, userId, primitiveFromGUID, primitiveToGUID);
            optionGUIDs = new ArrayList();
            optionGUIDs.add(mapGUID);
            thisTest.checkSchemaOptionOK(client, schemaOptionGUID, (String)activityName, userId, assetGUID, optionGUIDs);
            thisTest.checkAssetOK(client, assetGUID, (String)activityName, userId);
            client.removeSchemaType(userId, primitiveFromGUID);
            activityName = "deleteOneByOne - primitive From gone - " + primitiveFromGUID;
            thisTest.checkPrimitiveGone(client, primitiveFromGUID, (String)activityName, userId);
            thisTest.checkMapOK(client, mapGUID, (String)activityName, userId, null, primitiveToGUID);
            thisTest.checkSchemaOptionOK(client, schemaOptionGUID, (String)activityName, userId, assetGUID, optionGUIDs);
            thisTest.checkAssetOK(client, assetGUID, (String)activityName, userId);
            client.removeSchemaType(userId, primitiveToGUID);
            activityName = "deleteOneByOne - primitive To gone" + primitiveToGUID;
            thisTest.checkPrimitiveGone(client, primitiveToGUID, (String)activityName, userId);
            thisTest.checkMapOK(client, mapGUID, (String)activityName, userId, null, null);
            thisTest.checkSchemaOptionOK(client, schemaOptionGUID, (String)activityName, userId, assetGUID, optionGUIDs);
            thisTest.checkAssetOK(client, assetGUID, (String)activityName, userId);
            client.removeSchemaType(userId, mapGUID);
            activityName = "deleteOneByOne - map gone";
            thisTest.checkMapGone(client, mapGUID, (String)activityName, userId);
            thisTest.checkSchemaOptionOK(client, schemaOptionGUID, (String)activityName, userId, assetGUID, null);
            thisTest.checkAssetOK(client, assetGUID, (String)activityName, userId);
            client.removeSchemaType(userId, schemaOptionGUID);
            activityName = "deleteOneByOne - schema option gone";
            thisTest.checkSchemaOptionGone(client, schemaOptionGUID, assetGUID, (String)activityName, userId);
            thisTest.checkAssetOK(client, assetGUID, (String)activityName, userId);
            client.deleteAsset(userId, assetGUID);
            activityName = "deleteOneByOne - asset gone";
            thisTest.checkAssetGone(client, assetGUID, (String)activityName, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, (String)activityName, (Throwable)unexpectedError);
        }
    }

    private AssetOwner getAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getSchemaManagerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            return new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getSchemaManagerClient", (Throwable)unexpectedError);
        }
    }

    private void checkAssetGone(AssetOwner client, String assetGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            AssetElement retrievedElement = client.getAssetSummary(userId, assetGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Asset returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Retrieve returned)");
        }
        catch (InvalidParameterException retrievedElement) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkAssetOK(AssetOwner client, String assetGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            AssetElement retrievedElement = client.getAssetSummary(userId, assetGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no AssetElement from Retrieve)");
            }
            System.out.println("Asset Element: " + retrievedElement);
            this.validateAnchorGUID(activityName, (MetadataElement)retrievedElement);
            AssetProperties retrievedAsset = retrievedElement.getProperties();
            if (retrievedAsset == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no assetProperties from Retrieve)");
            }
            if (!assetName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!assetDisplayName.equals(retrievedAsset.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!assetDescription.equals(retrievedAsset.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            List assetList = client.getAssetsByName(userId, assetName, 0, 100);
            if (assetList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Asset for RetrieveByName)");
            }
            if (assetList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Asset list for RetrieveByName)");
            }
            if (assetList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Asset list for RetrieveByName contains" + assetList.size() + " elements)");
            }
            retrievedElement = (AssetElement)assetList.get(0);
            retrievedAsset = retrievedElement.getProperties();
            if (!assetName.equals(retrievedAsset.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!assetDisplayName.equals(retrievedAsset.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!assetDescription.equals(retrievedAsset.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            assetList = client.getAssetsByName(userId, assetName, 1, 100);
            if (assetList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Asset for RetrieveByName)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getAsset(AssetOwner client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getAsset";
        try {
            AssetProperties properties = new AssetProperties();
            properties.setQualifiedName(assetName);
            properties.setDisplayName(assetDisplayName);
            properties.setResourceDescription(assetDescription);
            properties.setTypeName("AvroFile");
            String assetGUID = client.addAssetToCatalog(userId, properties);
            if (assetGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(no GUID for Create)");
            }
            this.checkAssetOK(client, assetGUID, "getAsset", userId);
            return assetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAsset", (Throwable)unexpectedError);
        }
    }

    private void checkSchemaOptionGone(AssetOwner client, String schemaOptionGUID, String assetGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaTypeElement retrievedElement = client.getSchemaTypeByGUID(userId, schemaOptionGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaOption returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getSchemaOptionByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (assetGUID != null) {
            try {
                SchemaTypeElement assetSchemaType = client.getSchemaTypeForElement(userId, assetGUID, "Asset");
                if (assetSchemaType != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(No SchemaOption returned for getSchemaTypeForElement)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkSchemaOptionOK(AssetOwner client, String schemaOptionGUID, String activityName, String userId, String assetGUID, List<String> optionGUIDs) throws FVTUnexpectedCondition {
        try {
            SchemaTypeElement retrievedElement = client.getSchemaTypeByGUID(userId, schemaOptionGUID);
            this.validateSchemaOption(activityName + "(getSchemaTypeByGUID)", retrievedElement);
            List schemaOptionList = client.getSchemaTypeByName(userId, optionSchemaName, 0, 100);
            if (schemaOptionList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaOption for RetrieveByName)");
            }
            if (schemaOptionList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty SchemaOption list for RetrieveByName)");
            }
            if (schemaOptionList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaOption list for RetrieveByName contains" + schemaOptionList.size() + " elements)");
            }
            this.validateSchemaOption(activityName, (SchemaTypeElement)schemaOptionList.get(0));
            if (assetGUID != null) {
                retrievedElement = client.getSchemaTypeForElement(userId, assetGUID, "Asset");
                this.validateSchemaOption(activityName + "(getSchemaTypeForElement)", retrievedElement);
            }
            if (optionGUIDs != null) {
                List optionElements = retrievedElement.getSchemaOptions();
                if (optionElements == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no attached SchemaOption Elements)");
                }
                if (optionElements.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty attached SchemaOption Elements)");
                }
                if (optionElements.size() != optionGUIDs.size()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Attached SchemaOption Elements contains" + optionElements.size() + " elements)");
                }
                for (SchemaTypeElement optionElement : optionElements) {
                    if (optionGUIDs.contains(optionElement.getElementHeader().getGUID())) continue;
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad SchemaOption Element: " + optionElement + " not in " + optionGUIDs + ")");
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void validateSchemaOption(String activityName, SchemaTypeElement retrievedElement) throws FVTUnexpectedCondition {
        if (retrievedElement == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - no SchemaOptionElement)");
        }
        System.out.println("Schema Option Element: " + retrievedElement);
        this.validateAnchorGUID(activityName, (MetadataElement)retrievedElement);
        SchemaTypeProperties retrievedSchema = retrievedElement.getSchemaTypeProperties();
        if (retrievedSchema == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "- no SchemaOptionProperties");
        }
        if (!optionSchemaName.equals(retrievedSchema.getQualifiedName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad qualifiedName");
        }
        if (!optionSchemaDisplayName.equals(retrievedSchema.getDisplayName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad displayName");
        }
        if (!optionSchemaDescription.equals(retrievedSchema.getDescription())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " - Bad description");
        }
    }

    private String getSchemaOption(AssetOwner client, String assetGUID, String userId, List<String> optionGUIDs) throws FVTUnexpectedCondition {
        String activityName = "getSchemaOption";
        try {
            SchemaTypeProperties properties = new SchemaTypeProperties();
            properties.setQualifiedName(optionSchemaName);
            properties.setDisplayName(optionSchemaDisplayName);
            properties.setDescription(optionSchemaDescription);
            properties.setTypeName("SchemaTypeChoice");
            String schemaOptionGUID = client.createAnchoredSchemaType(userId, assetGUID, properties);
            if (schemaOptionGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaOption(no GUID for schemaCreate)");
            }
            client.setupSchemaTypeParent(userId, schemaOptionGUID, assetGUID, "Asset", null);
            if (optionGUIDs != null) {
                for (String optionGUID : optionGUIDs) {
                    client.setupSchemaElementRelationship(userId, schemaOptionGUID, optionGUID, "SchemaTypeOption", null);
                }
            }
            this.checkSchemaOptionOK(client, schemaOptionGUID, "getSchemaOption", userId, assetGUID, optionGUIDs);
            return schemaOptionGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getSchemaOption", (Throwable)unexpectedError);
        }
    }

    private void checkMapGone(AssetOwner client, String mapGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaTypeElement retrievedElement = client.getSchemaTypeByGUID(userId, mapGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Map returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getMapByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkMapOK(AssetOwner client, String mapGUID, String activityName, String userId, String mapFromGUID, String mapToGUID) throws FVTUnexpectedCondition {
        try {
            SchemaTypeElement retrievedElement = client.getSchemaTypeByGUID(userId, mapGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no MapElement from Retrieve)");
            }
            System.out.println("Map Element: " + retrievedElement);
            this.validateAnchorGUID(activityName, (MetadataElement)retrievedElement);
            SchemaTypeProperties retrievedMap = retrievedElement.getSchemaTypeProperties();
            if (retrievedMap == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no MapProperties from Retrieve)");
            }
            if (!mapName.equals(retrievedMap.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!mapDisplayName.equals(retrievedMap.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!mapDescription.equals(retrievedMap.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            List mapList = client.getSchemaTypeByName(userId, mapName, 0, 100);
            if (mapList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Map for RetrieveByName)");
            }
            if (mapList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Map list for RetrieveByName)");
            }
            if (mapList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Map list for RetrieveByName contains" + mapList.size() + " elements)");
            }
            retrievedElement = (SchemaTypeElement)mapList.get(0);
            retrievedMap = retrievedElement.getSchemaTypeProperties();
            if (!mapName.equals(retrievedMap.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!mapDisplayName.equals(retrievedMap.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!mapDescription.equals(retrievedMap.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            if (mapFromGUID == null && retrievedElement.getMapFromElement() != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Unexpected MapFrom from RetrieveByName) Retrieved element is: " + retrievedElement);
            }
            if (mapFromGUID != null && !mapFromGUID.equals(retrievedElement.getMapFromElement().getElementHeader().getGUID())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad MapFrom from RetrieveByName) Retrieved element is: " + retrievedElement);
            }
            if (mapToGUID == null && retrievedElement.getMapToElement() != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Unexpected MapTo from RetrieveByName) Retrieved element is: " + retrievedElement);
            }
            if (mapToGUID != null && !mapToGUID.equals(retrievedElement.getMapToElement().getElementHeader().getGUID())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad MapTo from RetrieveByName) Retrieved element is: " + retrievedElement);
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String createMap(AssetOwner client, String assetGUID, String userId, String mapFromGUID, String mapToGUID) throws FVTUnexpectedCondition {
        String activityName = "createMap";
        try {
            SchemaTypeProperties properties = new SchemaTypeProperties();
            properties.setQualifiedName(mapName);
            properties.setDisplayName(mapDisplayName);
            properties.setDescription(mapDescription);
            properties.setTypeName("MapSchemaType");
            String mapGUID = client.createAnchoredSchemaType(userId, assetGUID, properties);
            if (mapGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createMap(no GUID for mapCreate)");
            }
            if (mapFromGUID != null) {
                client.setupSchemaElementRelationship(userId, mapGUID, mapFromGUID, "MapFromElementType", null);
            }
            if (mapToGUID != null) {
                client.setupSchemaElementRelationship(userId, mapGUID, mapToGUID, "MapToElementType", null);
            }
            this.checkMapOK(client, mapGUID, "createMap", userId, mapFromGUID, mapToGUID);
            return mapGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createMap", (Throwable)unexpectedError);
        }
    }

    private void checkPrimitiveGone(AssetOwner client, String primitiveGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaTypeElement retrievedElement = client.getSchemaTypeByGUID(userId, primitiveGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Primitive returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getPrimitiveByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkPrimitiveOK(AssetOwner client, String primitiveGUID, String activityName, String userId, String primitiveName, String primitiveDisplayName, String primitiveDescription, String primitiveDataType) throws FVTUnexpectedCondition {
        try {
            SchemaTypeElement retrievedElement = client.getSchemaTypeByGUID(userId, primitiveGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (no PrimitiveElement from Retrieve)");
            }
            System.out.println("Primitive: " + retrievedElement);
            this.validateAnchorGUID(activityName, (MetadataElement)retrievedElement);
            SchemaTypeProperties retrievedType = retrievedElement.getSchemaTypeProperties();
            if (retrievedType == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (no PrimitiveProperties from Retrieve).  Element is " + retrievedElement);
            }
            if (!primitiveName.equals(retrievedType.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (Bad qualifiedName " + primitiveName + " from Retrieve).  Element is " + retrievedElement);
            }
            if (!primitiveDisplayName.equals(retrievedType.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (Bad displayName from Retrieve).  Element is " + retrievedElement);
            }
            if (!primitiveDescription.equals(retrievedType.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (Bad description from Retrieve).  Element is " + retrievedElement);
            }
            Map extendedProperties = retrievedType.getExtendedProperties();
            if (extendedProperties == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (Bad extendedProperties from Retrieve).  Element is " + retrievedElement);
            }
            if (!primitiveDataType.equals(extendedProperties.get("dataType"))) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (Bad data type from Retrieve).  Element is " + retrievedElement);
            }
            List primitiveList = client.getSchemaTypeByName(userId, primitiveName, 0, 100);
            if (primitiveList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (no Primitive for RetrieveByName).  Element is " + retrievedElement);
            }
            if (primitiveList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (Empty Primitive list for RetrieveByName).  Element is \" + retrievedElement");
            }
            if (primitiveList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " (Primitive list for RetrieveByName contains" + primitiveList.size() + " elements)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String createPrimitive(AssetOwner client, String assetGUID, String userId, String primitiveName, String primitiveDisplayName, String primitiveDescription, String primitiveDataType) throws FVTUnexpectedCondition {
        String activityName = "createPrimitive";
        try {
            SchemaTypeProperties properties = new SchemaTypeProperties();
            properties.setQualifiedName(primitiveName);
            properties.setDisplayName(primitiveDisplayName);
            properties.setDescription(primitiveDescription);
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("dataType", primitiveDataType);
            properties.setTypeName("PrimitiveSchemaType");
            properties.setExtendedProperties(extendedProperties);
            String columnGUID = client.createAnchoredSchemaType(userId, assetGUID, properties);
            if (columnGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createPrimitive(no GUID for columnCreate)");
            }
            this.checkPrimitiveOK(client, columnGUID, "createPrimitive", userId, primitiveName, primitiveDisplayName, primitiveDescription, primitiveDataType);
            return columnGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createPrimitive", (Throwable)unexpectedError);
        }
    }

    private void validateAnchorGUID(String activityName, MetadataElement metadataElement) {
        if (metadataElement.getElementHeader() != null && metadataElement.getElementHeader().getClassifications() != null) {
            for (ElementClassification classification : metadataElement.getElementHeader().getClassifications()) {
                if (!"Anchors".equals(classification.getClassificationName())) continue;
                System.out.println(metadataElement.getElementHeader().getType().getTypeName() + " element " + metadataElement.getElementHeader().getGUID() + " has anchor of " + classification.getClassificationProperties() + " in activity " + activityName);
            }
        }
    }
}

