/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AssetOwnerAuditCode {
    SERVICE_INITIALIZING("OMAS-ASSET-OWNER-0001", OMRSAuditLogRecordSeverity.INFO, "The Asset Owner Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Owner OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("OMAS-ASSET-OWNER-0003", OMRSAuditLogRecordSeverity.INFO, "The Asset Owner Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OMAS-ASSET-OWNER-0004", OMRSAuditLogRecordSeverity.INFO, "The Asset Owner Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Asset Owner OMAS instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-OWNER-0005", OMRSAuditLogRecordSeverity.ERROR, "The Asset Owner Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    ALL_ZONES("OMAS-ASSET-OWNER-0006", OMRSAuditLogRecordSeverity.INFO, "The Asset Owner Open Metadata Access Service (OMAS) is supporting all governance zones", "The access service has not been passed a list of governance zones in the SupportedZones property of the access services options.  This means it is providing access to all Assets irrespective of the zone(s) they are located in.", "No action is required.  This is part of the normal operation of the service."),
    SUPPORTED_ZONES("OMAS-ASSET-OWNER-0007", OMRSAuditLogRecordSeverity.INFO, "The Asset Owner Open Metadata Access Service (OMAS) is supporting the following governance zones {0}", "The access service was passed a list of governance zones in the SupportedZones property of the access services options.  This means it is only providing access to the Assets from these zone(s).", "No action is required.  This is part of the normal operation of the service."),
    BAD_CONFIG("OMAS-ASSET-OWNER-0008", OMRSAuditLogRecordSeverity.ERROR, "The Asset Owner Open Metadata Access Service (OMAS) has been passed an invalid value of {0} in the {1} property", "The access service has not been passed valid configuration.", "Correct the configuration and restart the service.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private AssetOwnerAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== AssetOwner Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> AssetOwner Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(AssetOwnerAuditCode.class);
    }
}

