/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.handlers.GovernanceZoneHandler;
import org.odpi.openmetadata.accessservices.assetowner.rest.ZoneListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ZoneRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ZoneResponse;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OriginRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OwnerRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetOwnerRESTServices {
    private static AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(AssetOwnerRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse addAssetToCatalog(String serverName, String userId, String typeName, AssetRequestBody requestBody) {
        String methodName = "addAssetToCatalog";
        log.debug("Calling method: addAssetToCatalog");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetToCatalog");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetToCatalog");
                handler.addAsset(userId, typeName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "addAssetToCatalog");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addAssetToCatalog", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAssetToCatalog", auditLog);
        }
        log.debug("Returning from method: addAssetToCatalog with response: " + response.toString());
        return response;
    }

    public GUIDResponse addSchemaToAsset(String serverName, String userId, String assetGUID, SchemaRequestBody requestBody) {
        String methodName = "addSchemaToAsset";
        log.debug("Calling method: addSchemaToAsset");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaToAsset");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addSchemaToAsset");
                handler.saveAssociatedSchemaType(userId, assetGUID, requestBody.getSchemaType(), requestBody.getSchemaAttributes(), "addSchemaToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addSchemaToAsset", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSchemaToAsset", auditLog);
        }
        log.debug("Returning from method: addSchemaToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse addSchemaAttributesToSchema(String serverName, String userId, String schemaTypeGUID, List<SchemaAttribute> requestBody) {
        String methodName = "addSchemaAttributesToSchema";
        log.debug("Calling method: addSchemaAttributesToSchema");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaAttributesToSchema");
                SchemaTypeHandler handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "addSchemaAttributesToSchema");
                handler.saveSchemaAttributes(userId, schemaTypeGUID, requestBody, "addSchemaAttributesToSchema");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addSchemaAttributesToSchema", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSchemaAttributesToSchema", auditLog);
        }
        log.debug("Returning from method: addSchemaAttributesToSchema with response: " + response.toString());
        return response;
    }

    public VoidResponse addConnectionToAsset(String serverName, String userId, String assetGUID, ConnectionRequestBody requestBody) {
        String methodName = "addConnectionToAsset";
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                String assetSummary = requestBody.getShortDescription();
                Connection connection = requestBody.getConnection();
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addConnectionToAsset");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addConnectionToAsset");
                handler.saveAssociatedConnection(userId, assetGUID, assetSummary, connection, "addConnectionToAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addConnectionToAsset", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addConnectionToAsset", auditLog);
        }
        log.debug("Returning from method: addConnectionToAsset with response: " + response.toString());
        return response;
    }

    public VoidResponse addSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "addSemanticAssignment";
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSemanticAssignment");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addSemanticAssignment");
            handler.saveSemanticAssignment(userId, assetGUID, glossaryTermGUID, assetElementGUID, "addSemanticAssignment");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSemanticAssignment", auditLog);
        }
        log.debug("Returning from method: addSemanticAssignment with response: " + response.toString());
        return response;
    }

    public VoidResponse addAssetOrigin(String serverName, String userId, String assetGUID, OriginRequestBody requestBody) {
        String methodName = "addAssetOrigin";
        log.debug("Calling method: addAssetOrigin");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetOrigin");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetOrigin");
                handler.addAssetOrigin(userId, assetGUID, requestBody.getOrganizationGUID(), requestBody.getBusinessCapabilityGUID(), requestBody.getOtherOriginValues(), "addAssetOrigin");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addAssetOrigin", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAssetOrigin", auditLog);
        }
        log.debug("Returning from method: addAssetOrigin with response: " + response.toString());
        return response;
    }

    public VoidResponse createGovernanceZone(String serverName, String userId, ZoneRequestBody requestBody) {
        String methodName = "createGovernanceZone";
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceZone");
                GovernanceZoneHandler handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "createGovernanceZone");
                handler.createGovernanceZone(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCriteria(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createGovernanceZone");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceZone", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createGovernanceZone", auditLog);
        }
        log.debug("Returning from method: createGovernanceZone with response: " + response.toString());
        return response;
    }

    public ZoneListResponse getGovernanceZones(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getGovernanceZones";
        ZoneListResponse response = new ZoneListResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZones");
            GovernanceZoneHandler handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZones");
            response.setGovernanceZone(handler.getGovernanceZones(userId, startingFrom, maximumResults, "getGovernanceZones"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getGovernanceZones", auditLog);
        }
        log.debug("Returning from method: getGovernanceZones with response: " + response.toString());
        return response;
    }

    public ZoneResponse getGovernanceZone(String serverName, String userId, String qualifiedName) {
        String methodName = "getGovernanceZone";
        ZoneResponse response = new ZoneResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZone");
            GovernanceZoneHandler handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZone");
            response.setGovernanceZone(handler.getGovernanceZone(userId, qualifiedName, "getGovernanceZone"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getGovernanceZone", auditLog);
        }
        log.debug("Returning from method: getGovernanceZone with response: " + response.toString());
        return response;
    }

    public VoidResponse updateAssetZones(String serverName, String userId, String assetGUID, List<String> assetZones) {
        String methodName = "updateAssetZones";
        log.debug("Calling method: updateAssetZones");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetZones");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetZones");
            handler.updateAssetZones(userId, assetGUID, assetZones, "updateAssetZones");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateAssetZones", auditLog);
        }
        log.debug("Returning from method: updateAssetZones with response: " + response.toString());
        return response;
    }

    public VoidResponse updateAssetOwner(String serverName, String userId, String assetGUID, OwnerRequestBody requestBody) {
        String methodName = "updateAssetOwner";
        log.debug("Calling method: updateAssetOwner");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetOwner");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetOwner");
                handler.updateAssetOwner(userId, assetGUID, requestBody.getOwnerId(), requestBody.getOwnerType(), "updateAssetOwner");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAssetOwner", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateAssetOwner", auditLog);
        }
        log.debug("Returning from method: updateAssetOwner with response: " + response.toString());
        return response;
    }

    public AssetsResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByName";
        log.debug("Calling method: getAssetsByName");
        AssetsResponse response = new AssetsResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setAssets(handler.getAssetsByName(userId, name, startFrom, pageSize, "getAssetsByName"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetsByName", auditLog);
        }
        log.debug("Returning from method: getAssetsByName with response: " + response.toString());
        return response;
    }

    public AssetsResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findAssets";
        log.debug("Calling method: findAssets");
        AssetsResponse response = new AssetsResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setAssets(handler.findAssets(userId, searchString, startFrom, pageSize, "findAssets"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findAssets", auditLog);
        }
        log.debug("Returning from method: findAssets with response: " + response.toString());
        return response;
    }

    public DiscoveryAnalysisReportListResponse getDiscoveryAnalysisReports(String serverName, String userId, String assetGUID, int startingFrom, int maxPageSize) {
        String methodName = "getDiscoveryAnalysisReports";
        log.debug("Calling method: getDiscoveryAnalysisReports");
        DiscoveryAnalysisReportListResponse response = new DiscoveryAnalysisReportListResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReports");
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryAnalysisReports");
            response.setDiscoveryAnalysisReports(handler.getDiscoveryAnalysisReports(userId, assetGUID, startingFrom, maxPageSize, "getDiscoveryAnalysisReports"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryAnalysisReports", auditLog);
        }
        log.debug("Returning from method: getDiscoveryAnalysisReports with response: " + response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getDiscoveryReportAnnotations";
        log.debug("Calling method: getDiscoveryReportAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        OMRSAuditLog auditLog = null;
        AnnotationStatus annotationStatus = null;
        if (requestBody != null) {
            annotationStatus = requestBody.getAnnotationStatus();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryReportAnnotations");
            response.setAnnotations(handler.getDiscoveryReportAnnotations(userId, discoveryReportGUID, annotationStatus, startingFrom, maximumResults, "getDiscoveryReportAnnotations"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        log.debug("Returning from method: getDiscoveryReportAnnotations with response: " + response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String userId, String annotationGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getExtendedAnnotations";
        log.debug("Calling method: getExtendedAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        OMRSAuditLog auditLog = null;
        AnnotationStatus annotationStatus = null;
        if (requestBody != null) {
            annotationStatus = requestBody.getAnnotationStatus();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(userId, annotationGUID, annotationStatus, startingFrom, maximumResults, "getExtendedAnnotations"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getExtendedAnnotations", auditLog);
        }
        log.debug("Returning from method: getExtendedAnnotations with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "deleteAsset";
        log.debug("Calling method: deleteAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAsset");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "deleteAsset");
            handler.removeAsset(userId, assetGUID, "deleteAsset");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "deleteAsset", auditLog);
        }
        log.debug("Returning from method: deleteAsset with response: " + response.toString());
        return response;
    }
}

