/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.ffdc.AssetOwnerErrorCode;
import org.odpi.openmetadata.accessservices.assetowner.handlers.FileSystemHandler;
import org.odpi.openmetadata.accessservices.assetowner.handlers.GovernanceZoneHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetOwnerServicesInstance
extends OCFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.ASSET_OWNER_OMAS;
    private GovernanceZoneHandler governanceZoneHandler;
    private FileSystemHandler fileSystemHandler;

    public AssetOwnerServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, OMRSAuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceName() + " OMAS", repositoryConnector, supportedZones, defaultZones, auditLog, localServerUserId, maxPageSize);
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            AssetOwnerErrorCode errorCode = AssetOwnerErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.governanceZoneHandler = new GovernanceZoneHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper);
        this.fileSystemHandler = new FileSystemHandler(this.serviceName, this.serverName, supportedZones, this.assetHandler, this.schemaTypeHandler, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper);
    }

    GovernanceZoneHandler getGovernanceZoneHandler() {
        return this.governanceZoneHandler;
    }

    FileSystemHandler getFileSystemHandler() {
        return this.fileSystemHandler;
    }
}

