/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import org.odpi.openmetadata.accessservices.assetowner.properties.FileSystem;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FileSystemConverter
extends ReferenceableConverter {
    public FileSystemConverter(EntityDetail zoneEntity, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(zoneEntity, repositoryHelper, serviceName);
    }

    public FileSystem getFileSystemBean() {
        FileSystem bean = null;
        if (this.entity != null) {
            bean = new FileSystem();
            this.updateBean(bean);
        }
        return bean;
    }

    private void updateBean(FileSystem bean) {
        String methodName = "updateBean";
        if (this.entity != null) {
            super.updateBean((Referenceable)bean);
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "updateBean"));
                bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "updateBean"));
                bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "updateBean"));
                bean.setFileSystemType(this.repositoryHelper.removeStringProperty(this.serviceName, "type", instanceProperties, "updateBean"));
                bean.setVersion(this.repositoryHelper.removeStringProperty(this.serviceName, "version", instanceProperties, "updateBean"));
                bean.setPatchLevel(this.repositoryHelper.removeStringProperty(this.serviceName, "patchLevel", instanceProperties, "updateBean"));
                bean.setSource(this.repositoryHelper.removeStringProperty(this.serviceName, "source", instanceProperties, "updateBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "updateBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
            if ((instanceProperties = super.getClassificationProperties("FileSystem")) != null) {
                bean.setFormat(this.repositoryHelper.getStringProperty(this.serviceName, "format", instanceProperties, "updateBean"));
                bean.setDisplayName(this.repositoryHelper.getStringProperty(this.serviceName, "encryption", instanceProperties, "updateBean"));
            }
        }
    }
}

