/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OriginRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OwnerRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.LoggerFactory;

public class AssetOwnerRESTServices {
    private static AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetOwnerRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse addAssetToCatalog(String serverName, String userId, String typeName, AssetRequestBody requestBody) {
        String methodName = "addAssetToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetToCatalog");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetToCatalog");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetToCatalog");
                handler.addAsset(userId, typeName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "addAssetToCatalog");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetToCatalog", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAssetToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addSchemaToAsset(String serverName, String userId, String assetGUID, SchemaRequestBody requestBody) {
        String methodName = "addSchemaToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaToAsset");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaToAsset");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addSchemaToAsset");
                handler.saveAssociatedSchemaType(userId, assetGUID, requestBody.getSchemaType(), requestBody.getSchemaAttributes(), "addSchemaToAsset");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaToAsset", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSchemaToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSchemaAttributesToSchema(String serverName, String userId, String schemaTypeGUID, List<SchemaAttribute> requestBody) {
        String methodName = "addSchemaAttributesToSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaAttributesToSchema");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaAttributesToSchema");
                SchemaTypeHandler handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "addSchemaAttributesToSchema");
                handler.saveSchemaAttributes(userId, schemaTypeGUID, requestBody, "addSchemaAttributesToSchema");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaAttributesToSchema", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSchemaAttributesToSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addConnectionToAsset(String serverName, String userId, String assetGUID, ConnectionRequestBody requestBody) {
        String methodName = "addConnectionToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addConnectionToAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                String assetSummary = requestBody.getShortDescription();
                Connection connection = requestBody.getConnection();
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addConnectionToAsset");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addConnectionToAsset");
                handler.saveAssociatedConnection(userId, assetGUID, assetSummary, connection, "addConnectionToAsset");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addConnectionToAsset", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addConnectionToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, NullRequestBody requestBody) {
        String methodName = "addSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSemanticAssignment");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSemanticAssignment");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addSemanticAssignment");
            handler.saveSemanticAssignment(userId, assetGUID, glossaryTermGUID, "addSemanticAssignment");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "addSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSemanticAssignment");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSemanticAssignment");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addSemanticAssignment");
            handler.saveSemanticAssignment(userId, assetGUID, glossaryTermGUID, assetElementGUID, "addSemanticAssignment");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, NullRequestBody requestBody) {
        String methodName = "removeSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSemanticAssignment");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSemanticAssignment");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeSemanticAssignment");
            handler.removeSemanticAssignment(userId, assetGUID, glossaryTermGUID, "removeSemanticAssignment");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "removeSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSemanticAssignment");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSemanticAssignment");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeSemanticAssignment");
            handler.removeSemanticAssignment(userId, assetGUID, glossaryTermGUID, assetElementGUID, "removeSemanticAssignment");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addAssetOrigin(String serverName, String userId, String assetGUID, OriginRequestBody requestBody) {
        String methodName = "addAssetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetOrigin");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetOrigin");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetOrigin");
                handler.addAssetOrigin(userId, assetGUID, requestBody.getOrganizationGUID(), requestBody.getBusinessCapabilityGUID(), requestBody.getOtherOriginValues(), "addAssetOrigin");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetOrigin", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAssetOrigin(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "addAssetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetOrigin");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetOrigin");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetOrigin");
                handler.removeAssetOrigin(userId, assetGUID, "addAssetOrigin");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetOrigin", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetZones(String serverName, String userId, String assetGUID, List<String> assetZones) {
        String methodName = "updateAssetZones";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetZones");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetZones");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetZones");
            handler.updateAssetZones(userId, assetGUID, assetZones, "updateAssetZones");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateAssetZones", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetOwner(String serverName, String userId, String assetGUID, OwnerRequestBody requestBody) {
        String methodName = "updateAssetOwner";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetOwner");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetOwner");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetOwner");
                handler.updateAssetOwner(userId, assetGUID, requestBody.getOwnerId(), requestBody.getOwnerType(), "updateAssetOwner");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateAssetOwner", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateAssetOwner", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String assetGUID, SecurityTagsRequestBody requestBody) {
        String methodName = "addSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addSecurityTags");
                handler.addSecurityTags(userId, assetGUID, requestBody.getSecurityLabels(), requestBody.getSecurityProperties(), "addSecurityTags");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String assetGUID, String assetElementGUID, SecurityTagsRequestBody requestBody) {
        String methodName = "addSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
                AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "addSecurityTags");
                handler.addSecurityTags(userId, assetGUID, assetElementGUID, requestBody.getSecurityLabels(), requestBody.getSecurityProperties(), "addSecurityTags");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "removeSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSecurityTags");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSecurityTags");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeSecurityTags");
            handler.removeSecurityTags(userId, assetGUID, "removeSecurityTags");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "removeSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSecurityTags");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSecurityTags");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "removeSecurityTags");
            handler.removeSecurityTags(userId, assetGUID, assetElementGUID, "removeSecurityTags");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "removeSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetsResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        AssetsResponse response = new AssetsResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setAssets(handler.getAssetsByName(userId, name, startFrom, pageSize, "getAssetsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetsResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        AssetsResponse response = new AssetsResponse();
        OMRSAuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setAssets(handler.findAssets(userId, searchString, startFrom, pageSize, "findAssets"));
            response.setStartingFromElement(startFrom);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryAnalysisReportListResponse getDiscoveryAnalysisReports(String serverName, String userId, String assetGUID, int startingFrom, int maxPageSize) {
        String methodName = "getDiscoveryAnalysisReports";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryAnalysisReports");
        DiscoveryAnalysisReportListResponse response = new DiscoveryAnalysisReportListResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReports");
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryAnalysisReports");
            response.setDiscoveryAnalysisReports(handler.getDiscoveryAnalysisReports(userId, assetGUID, startingFrom, maxPageSize, "getDiscoveryAnalysisReports"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryAnalysisReports", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getDiscoveryReportAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryReportAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        OMRSAuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
                DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryReportAnnotations");
                response.setAnnotations(handler.getDiscoveryReportAnnotations(userId, discoveryReportGUID, requestBody.getAnnotationStatus(), startingFrom, maximumResults, "getDiscoveryReportAnnotations"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getDiscoveryReportAnnotations", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String userId, String annotationGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getExtendedAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExtendedAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        OMRSAuditLog auditLog = null;
        AnnotationStatus annotationStatus = null;
        if (requestBody != null) {
            annotationStatus = requestBody.getAnnotationStatus();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(userId, annotationGUID, annotationStatus, startingFrom, maximumResults, "getExtendedAnnotations"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getExtendedAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "deleteAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteAsset");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAsset");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "deleteAsset");
            handler.removeAsset(userId, assetGUID, "deleteAsset");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "deleteAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

