/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AssetOwnerAuditCode {
    SERVICE_INITIALIZING("OMAS-ASSET-OWNER-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Owner Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Owner OMAS.  This service enables tools to capture information about assets, build a catalog and set up information about how these assets should be governed.", "No action is required if this service is expected to be started in this server.  If this service is not required then it can be removed from the access service list in the configuration document for this server.  It will then not be started the next time the server starts up."),
    SERVICE_INITIALIZED("OMAS-ASSET-OWNER-0003", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Owner Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that this service has initialized successfully and has the correct set of supported zones and default zones defined.  Investigate any reported errors.  Also ensure that theenterprise repository services and the OCF metadata management services are initialized."),
    SERVICE_SHUTDOWN("OMAS-ASSET-OWNER-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Owner Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Asset Owner OMAS instance.", "No action is required is this shutdown was intended."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-OWNER-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The Asset Owner Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private AssetOwnerAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== AssetOwner Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> AssetOwner Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(AssetOwnerAuditCode.class);
    }
}

